"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesTableExpandedRow = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../../../../../common/log_analysis");
var _log_entry_examples = require("../../../../../components/logging/log_entry_examples/log_entry_examples");
var _use_log_entry_examples = require("../../use_log_entry_examples");
var _log_entry_example = require("./log_entry_example");
var _use_log_ml_job_id_formats_shim = require("../../../shared/use_log_ml_job_id_formats_shim");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXAMPLE_COUNT = 5;
const examplesTitle = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableExamplesTitle', {
  defaultMessage: 'Example log entries'
});
const AnomaliesTableExpandedRow = ({
  anomaly,
  timeRange
}) => {
  const {
    logViewReference
  } = (0, _public.useLogViewContext)();
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  if (logViewReference.type === 'log-view-inline') {
    throw new Error('Logs ML features only support persisted Log Views');
  }
  const {
    getLogEntryExamples,
    hasFailedLoadingLogEntryExamples,
    isLoadingLogEntryExamples,
    logEntryExamples
  } = (0, _use_log_entry_examples.useLogEntryExamples)({
    dataset: anomaly.dataset,
    endTime: anomaly.startTime + anomaly.duration,
    exampleCount: EXAMPLE_COUNT,
    logViewReference,
    idFormat: idFormats === null || idFormats === void 0 ? void 0 : idFormats[_log_analysis.logEntryRateJobType],
    startTime: anomaly.startTime,
    categoryId: (0, _log_analysis.isCategoryAnomaly)(anomaly) ? anomaly.categoryId : undefined
  });
  (0, _useMount.default)(() => {
    getLogEntryExamples();
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExpandedContentWrapper, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, examplesTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_log_entry_examples.LogEntryExampleMessages, {
    isLoading: isLoadingLogEntryExamples,
    hasFailedLoading: hasFailedLoadingLogEntryExamples,
    hasResults: logEntryExamples.length > 0,
    exampleCount: EXAMPLE_COUNT,
    onReload: getLogEntryExamples
  }, logEntryExamples.length > 0 ? /*#__PURE__*/_react.default.createElement(_log_entry_example.LogEntryExampleMessageTable, {
    examples: logEntryExamples,
    timeRange: timeRange,
    anomaly: anomaly
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: `${(0, _numeral.default)(anomaly.typical).format('0.[00]a')} ${_i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesExpandedRowTypicalRateTitle', {
      defaultMessage: '{typicalCount, plural, one {message} other {messages}}',
      values: {
        typicalCount: anomaly.typical
      }
    })}`,
    description: _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesExpandedRowTypicalRateDescription', {
      defaultMessage: 'Typical'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: `${(0, _numeral.default)(anomaly.actual).format('0.[00]a')} ${_i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesExpandedRowActualRateTitle', {
      defaultMessage: '{actualCount, plural, one {message} other {messages}}',
      values: {
        actualCount: anomaly.actual
      }
    })}`,
    description: _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesExpandedRowActualRateDescription', {
      defaultMessage: 'Actual'
    })
  }))))));
};
exports.AnomaliesTableExpandedRow = AnomaliesTableExpandedRow;
const ExpandedContentWrapper = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  overflow: hidden;
`;