"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchParams = exports.RedirectToNodeDetail = exports.REDIRECT_NODE_DETAILS_TO_KEY = exports.REDIRECT_NODE_DETAILS_FROM_KEY = exports.REDIRECT_ASSET_DETAILS_KEY = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _common = require("@kbn/observability-shared-plugin/common");
var _constants = require("../../components/asset_details/constants");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REDIRECT_NODE_DETAILS_FROM_KEY = exports.REDIRECT_NODE_DETAILS_FROM_KEY = 'from';
const REDIRECT_NODE_DETAILS_TO_KEY = exports.REDIRECT_NODE_DETAILS_TO_KEY = 'to';
const REDIRECT_ASSET_DETAILS_KEY = exports.REDIRECT_ASSET_DETAILS_KEY = 'assetDetails';
const getAssetDetailsQueryParams = queryParams => {
  const from = queryParams.get(REDIRECT_NODE_DETAILS_FROM_KEY);
  const to = queryParams.get(REDIRECT_NODE_DETAILS_TO_KEY);
  const assetDetailsParam = queryParams.get(REDIRECT_ASSET_DETAILS_KEY);
  return {
    [_constants.ASSET_DETAILS_URL_STATE_KEY]: {
      ...(assetDetailsParam ? _rison.default.decode(assetDetailsParam) : undefined),
      dateRange: {
        from: from ? new Date(parseFloat(from)).toISOString() : undefined,
        to: to ? new Date(parseFloat(to)).toISOString() : undefined
      }
    }
  };
};
const getNodeDetailSearch = queryParams => {
  const from = queryParams.get(REDIRECT_NODE_DETAILS_FROM_KEY);
  const to = queryParams.get(REDIRECT_NODE_DETAILS_TO_KEY);
  return {
    _a: {
      time: from && to ? {
        from: new Date(parseFloat(from)).toISOString(),
        interval: '>=1m',
        to: new Date(parseFloat(to)).toISOString()
      } : undefined
    }
  };
};
const getSearchParams = (nodeType, queryParams) => Object.values(_common.SupportedAssetTypes).includes(nodeType) ? getAssetDetailsQueryParams(queryParams) : getNodeDetailSearch(queryParams);
exports.getSearchParams = getSearchParams;
const RedirectToNodeDetail = () => {
  const {
    params: {
      nodeType,
      nodeId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const location = (0, _reactRouterDom.useLocation)();
  const baseLocator = share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  (0, _react.useEffect)(() => {
    const queryParams = new URLSearchParams(location.search);
    const search = getSearchParams(nodeType, queryParams);
    baseLocator === null || baseLocator === void 0 ? void 0 : baseLocator.navigate({
      ...search,
      assetType: nodeType,
      assetId: nodeId,
      state: location.state
    });
  }, [baseLocator, location.search, location.state, nodeId, nodeType]);
  return null;
};
exports.RedirectToNodeDetail = RedirectToNodeDetail;