"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCustomizationMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogCustomizationMenu extends React.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isShown: false
    });
    (0, _defineProperty2.default)(this, "show", () => {
      this.setState({
        isShown: true
      });
    });
    (0, _defineProperty2.default)(this, "hide", () => {
      this.setState({
        isShown: false
      });
    });
    (0, _defineProperty2.default)(this, "toggleVisibility", () => {
      this.setState(state => ({
        isShown: !state.isShown
      }));
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isShown
    } = this.state;
    const menuButton = /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraCustomizeButton",
      color: "text",
      iconType: "eye",
      onClick: this.toggleVisibility,
      size: "xs"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.customizeLogs.customizeButtonLabel",
      defaultMessage: "Customize"
    }));
    return /*#__PURE__*/React.createElement(_eui.EuiPopover, {
      id: "customizePopover",
      button: menuButton,
      closePopover: this.hide,
      isOpen: isShown,
      anchorPosition: "downRight",
      ownFocus: true
    }, /*#__PURE__*/React.createElement(CustomizationMenuContent, null, children));
  }
}
exports.LogCustomizationMenu = LogCustomizationMenu;
const CustomizationMenuContent = _common.euiStyled.div`
  min-width: 200px;
`;