"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _states = require("./states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateBadge = ({
  state
}) => {
  switch (state) {
    case 'running':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "success"
      }, _states.STATE_NAMES.running);
    case 'sleeping':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default"
      }, _states.STATE_NAMES.sleeping);
    case 'dead':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "danger"
      }, _states.STATE_NAMES.dead);
    case 'stopped':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, _states.STATE_NAMES.stopped);
    case 'idle':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "primary"
      }, _states.STATE_NAMES.idle);
    case 'zombie':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "danger"
      }, _states.STATE_NAMES.zombie);
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, _states.STATE_NAMES.unknown);
  }
};
exports.StateBadge = StateBadge;