"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _metadata_summary_list = require("./metadata_summary/metadata_summary_list");
var _alerts = require("./alerts/alerts");
var _kpi_grid = require("./kpis/kpi_grid");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _use_data_views = require("../../hooks/use_data_views");
var _use_date_picker = require("../../hooks/use_date_picker");
var _metadata_error_callout = require("../../components/metadata_error_callout");
var _cpu_profiling_prompt = require("./kpis/cpu_profiling_prompt");
var _services = require("./services");
var _metrics = require("./metrics/metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Overview = () => {
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset,
    renderMode
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading,
    error: fetchMetadataError
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    metrics
  } = (0, _use_data_views.useDataViewsContext)();
  const isFullPageView = renderMode.mode === 'page';
  const metadataSummarySection = isFullPageView ? /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryList, {
    metadata: metadata,
    loading: metadataLoading,
    assetType: asset.type
  }) : /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryListCompact, {
    metadata: metadata,
    loading: metadataLoading,
    assetType: asset.type
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_kpi_grid.KPIGrid, {
    assetId: asset.id,
    assetType: asset.type,
    dateRange: dateRange,
    dataView: metrics.dataView
  }), asset.type === 'host' ? /*#__PURE__*/_react.default.createElement(_cpu_profiling_prompt.CpuProfilingPrompt, null) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, fetchMetadataError && !metadataLoading ? /*#__PURE__*/_react.default.createElement(_metadata_error_callout.MetadataErrorCallout, null) : metadataSummarySection, /*#__PURE__*/_react.default.createElement(SectionSeparator, null)), asset.type === 'host' || asset.type === 'container' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts.AlertsSummaryContent, {
    assetId: asset.id,
    assetType: asset.type,
    dateRange: dateRange
  }), /*#__PURE__*/_react.default.createElement(SectionSeparator, null)) : null, asset.type === 'host' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_services.ServicesContent, {
    hostName: asset.id,
    dateRange: dateRange
  }), /*#__PURE__*/_react.default.createElement(SectionSeparator, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metrics.MetricsContent, {
    assetId: asset.id,
    assetType: asset.type,
    dateRange: dateRange,
    dataView: metrics.dataView
  })));
};
exports.Overview = Overview;
const SectionSeparator = () => /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "m",
  css: (0, _react2.css)`
      margin-bottom: 0;
    `
});