"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProcessListContext = exports.ProcessListContextProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _metrics_source = require("../../../containers/metrics_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProcessListParams(props) {
  const {
    hostTerm,
    to
  } = props;
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  return {
    hostTerm,
    indexPattern: metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices,
    to
  };
}
const ProcessListContext = (0, _constate.default)(useProcessListParams);
const [ProcessListContextProvider, useProcessListContext] = ProcessListContext;
exports.useProcessListContext = useProcessListContext;
exports.ProcessListContextProvider = ProcessListContextProvider;