"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogThresholdRuleType = createLogThresholdRuleType;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/logs-shared-plugin/common");
var _log_threshold = require("../../../common/alerting/logs/log_threshold");
var _use_kibana = require("../../hooks/use_kibana");
var _rule_data_formatters = require("./rule_data_formatters");
var _validation = require("./validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const logThresholdDefaultActionMessage = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active.

'{{^context.isRatio}}{{#context.group}}{{context.group}}' - '{{/context.group}}{{context.matchingDocuments}}' log entries have matched the following conditions: '{{context.conditions}}{{/context.isRatio}}'
'{{#context.isRatio}}{{#context.group}}{{context.group}}' - '{{/context.group}}' Ratio of the count of log entries matching '{{context.numeratorConditions}}' to the count of log entries matching '{{context.denominatorConditions}}' was '{{context.ratio}}{{/context.isRatio}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const logThresholdDefaultRecoveryMessage = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.defaultRecoveryMessage', {
  defaultMessage: `Recovered: '{{context.reason}}'
    
    '{{rule.name}}' has recovered.

[View alert details]('{{context.alertDetailsUrl}}')
`
});
function createLogThresholdRuleType(core, urlService) {
  const ruleParamsExpression = (0, _use_kibana.createLazyComponentWithKibanaContext)(core, () => Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression_editor/editor'))));
  const alertDetailsAppSection = (0, _use_kibana.createLazyComponentWithKibanaContext)(core, () => Promise.resolve().then(() => _interopRequireWildcard(require('./components/alert_details_app_section'))));
  const {
    logsLocator
  } = (0, _common.getLogsLocatorsFromUrlService)(urlService);
  return {
    id: _log_threshold.LOG_DOCUMENT_COUNT_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.infra.logs.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when the log aggregation exceeds the threshold.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.logsThreshold}`;
    },
    alertDetailsAppSection,
    ruleParamsExpression,
    validate: _validation.validateExpression,
    defaultActionMessage: logThresholdDefaultActionMessage,
    defaultRecoveryMessage: logThresholdDefaultRecoveryMessage,
    requiresAppContext: false,
    format: (0, _rule_data_formatters.createRuleFormatter)(logsLocator),
    priority: 30
  };
}