"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageAlertsContextMenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageAlertsContextMenuItem = () => {
  const {
    services: {
      observability
    }
  } = (0, _public.useKibana)();
  const manageRulesLinkProps = observability.useRulesLink();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    icon: "tableOfContents",
    key: "manageLink"
  }, manageRulesLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.alerting.manageAlerts",
    defaultMessage: "Manage rules"
  }));
};
exports.ManageAlertsContextMenuItem = ManageAlertsContextMenuItem;