"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrefilledInventoryAlertFlyout = exports.AlertFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _public = require("@kbn/kibana-react-plugin/public");
var _metrics = require("../../../../common/alerting/metrics");
var _triggers_actions_context = require("../../../containers/triggers_actions_context");
var _use_alert_prefill = require("../../use_alert_prefill");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertFlyout = ({
  options,
  nodeType,
  filter,
  visible,
  setVisible
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    triggersActionsUI
  } = (0, _react.useContext)(_triggers_actions_context.TriggerActionsContext);
  const onCloseFlyout = (0, _react.useCallback)(() => setVisible(false), [setVisible]);
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const {
    customMetrics = [],
    accountId,
    region
  } = inventoryPrefill;
  const AddAlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUI) return null;
    const {
      ruleTypeRegistry,
      actionTypeRegistry
    } = triggersActionsUI;
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
      plugins: {
        ...services,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      consumer: 'infrastructure',
      onCancel: onCloseFlyout,
      onSubmit: onCloseFlyout,
      ruleTypeId: _metrics.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID,
      initialMetadata: {
        accountId,
        options,
        nodeType,
        filter,
        customMetrics,
        region
      },
      shouldUseRuleProducer: true
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [triggersActionsUI, visible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && AddAlertFlyout);
};
exports.AlertFlyout = AlertFlyout;
const PrefilledInventoryAlertFlyout = ({
  onClose
}) => {
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const {
    nodeType,
    metric,
    filterQuery
  } = inventoryPrefill;
  return /*#__PURE__*/_react.default.createElement(AlertFlyout, {
    options: {
      metric
    },
    nodeType: nodeType,
    filter: filterQuery,
    visible: true,
    setVisible: onClose
  });
};
exports.PrefilledInventoryAlertFlyout = PrefilledInventoryAlertFlyout;