"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInInferenceContext = isInInferenceContext;
var _api = require("@opentelemetry/api");
var _baggage = require("./baggage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isInInferenceContext(context) {
  var _baggage$getEntry;
  // Only capture if span is part of an inference trace/span
  // baggage is set in ../create_inference_active_span.ts
  const baggage = _api.propagation.getBaggage(context);
  const inInferenceContext = (baggage === null || baggage === void 0 ? void 0 : (_baggage$getEntry = baggage.getEntry(_baggage.BAGGAGE_TRACKING_BEACON_KEY)) === null || _baggage$getEntry === void 0 ? void 0 : _baggage$getEntry.value) === _baggage.BAGGAGE_TRACKING_BEACON_VALUE;
  return inInferenceContext;
}