"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActiveInferenceSpan = createActiveInferenceSpan;
var _sdk = require("@elastic/opentelemetry-node/sdk");
var _api = require("@opentelemetry/api");
var _baggage = require("./baggage");
var _root_inference_span = require("./root_inference_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createActiveInferenceSpan(options, cb) {
  var _ref, _apm$currentSpan, _baggage$getEntry;
  const tracer = _api.trace.getTracer('inference');
  const {
    name,
    ...attributes
  } = typeof options === 'string' ? {
    name: options
  } : options;
  const apm = {
    currentTransaction: {
      ids: {
        'trace.id': undefined,
        'span.id': undefined,
        'transaction.id': undefined
      }
    },
    currentSpan: {
      ids: {
        'trace.id': undefined,
        'span.id': undefined,
        'transaction.id': undefined
      }
    }
  };
  const currentTransaction = apm.currentTransaction;
  const parentSpan = _api.trace.getActiveSpan();
  const parentSpanContext = parentSpan === null || parentSpan === void 0 ? void 0 : parentSpan.spanContext();
  const parentTraceId = (parentSpanContext === null || parentSpanContext === void 0 ? void 0 : parentSpanContext.traceId) || (currentTransaction === null || currentTransaction === void 0 ? void 0 : currentTransaction.ids['trace.id']);
  const parentSpanId = (_ref = (parentSpanContext === null || parentSpanContext === void 0 ? void 0 : parentSpanContext.spanId) || ((_apm$currentSpan = apm.currentSpan) === null || _apm$currentSpan === void 0 ? void 0 : _apm$currentSpan.ids['span.id'])) !== null && _ref !== void 0 ? _ref : currentTransaction === null || currentTransaction === void 0 ? void 0 : currentTransaction.ids['transaction.id'];
  let parentContext = _api.context.active();
  if (_sdk.core.isTracingSuppressed(parentContext)) {
    return cb();
  }
  let baggage = _api.propagation.getBaggage(parentContext);
  let isRootInferenceSpan = false;
  if (!baggage) {
    baggage = _api.propagation.createBaggage({
      [_baggage.BAGGAGE_TRACKING_BEACON_KEY]: {
        value: _baggage.BAGGAGE_TRACKING_BEACON_VALUE
      }
    });
    isRootInferenceSpan = true;
  } else if (((_baggage$getEntry = baggage.getEntry(_baggage.BAGGAGE_TRACKING_BEACON_KEY)) === null || _baggage$getEntry === void 0 ? void 0 : _baggage$getEntry.value) !== _baggage.BAGGAGE_TRACKING_BEACON_VALUE) {
    isRootInferenceSpan = true;
    baggage = baggage.setEntry(_baggage.BAGGAGE_TRACKING_BEACON_KEY, {
      value: _baggage.BAGGAGE_TRACKING_BEACON_VALUE
    });
  }
  parentContext = _api.propagation.setBaggage(parentContext, baggage);
  if ((!parentSpan || !parentSpan.isRecording()) && parentSpanId && parentTraceId) {
    parentContext = _api.trace.setSpanContext(parentContext, {
      spanId: parentSpanId,
      traceId: parentTraceId,
      traceFlags: 1
    });
  }
  return tracer.startActiveSpan(name, {
    attributes: {
      ...attributes,
      [_root_inference_span.IS_ROOT_INFERENCE_SPAN_ATTRIBUTE_NAME]: isRootInferenceSpan
    }
  }, parentContext, span => {
    return cb(span);
  });
}