"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messageToAnonymizationRecords = messageToAnonymizationRecords;
var _lodash = require("lodash");
var _get_anonymizable_message_parts = require("./get_anonymizable_message_parts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function messageToAnonymizationRecords(message) {
  const anonymizableMessage = (0, _get_anonymizable_message_parts.getAnonymizableMessageParts)(message);
  const {
    content,
    ...rest
  } = anonymizableMessage;
  return {
    ...(content && typeof content === 'string' ? {
      content
    } : {}),
    ...(content && typeof content !== 'string' ? {
      contentParts: JSON.stringify(content)
    } : {}),
    ...(!(0, _lodash.isEmpty)(rest) ? {
      data: JSON.stringify(rest)
    } : {})
  };
}