"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messageFromAnonymizationRecords = messageFromAnonymizationRecords;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function messageFromAnonymizationRecords(map) {
  const anonymizableMessage = map;
  const {
    content,
    contentParts,
    data
  } = anonymizableMessage;
  return {
    ...(content ? {
      content
    } : {}),
    ...(contentParts ? {
      content: JSON.parse(contentParts)
    } : {}),
    ...(data ? JSON.parse(data) : {})
  };
}