"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anonymizeMessages = anonymizeMessages;
var _lodash = require("lodash");
var _anonymize_records = require("./anonymize_records");
var _message_from_anonymization_records = require("./message_from_anonymization_records");
var _message_to_anonymization_records = require("./message_to_anonymization_records");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function anonymizeMessages({
  system,
  messages,
  anonymizationRules,
  regexWorker,
  esClient
}) {
  const rules = anonymizationRules.filter(rule => rule.enabled);
  if (!rules.length) {
    return {
      messages,
      anonymizations: []
    };
  }
  const toAnonymize = [...messages.map(_message_to_anonymization_records.messageToAnonymizationRecords),
  // put system message last so we can use position-based lookups
  // when iterating over `records`
  ...(system ? [{
    system
  }] : [])];
  const {
    records,
    anonymizations
  } = await (0, _anonymize_records.anonymizeRecords)({
    input: toAnonymize,
    anonymizationRules: rules,
    regexWorker,
    esClient
  });
  const anonymizedMessages = messages.map((original, index) => {
    const map = records[index];
    return (0, _lodash.merge)({}, original, (0, _message_from_anonymization_records.messageFromAnonymizationRecords)(map));
  });
  const anonymizedSystem = records.find(r => 'system' in r);
  return {
    system: anonymizedSystem === null || anonymizedSystem === void 0 ? void 0 : anonymizedSystem.system,
    messages: anonymizedMessages,
    anonymizations
  };
}