"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOutputApi = createOutputApi;
var _inferenceCommon = require("@kbn/inference-common");
var _rxjs = require("rxjs");
var _ensure_multi_turn = require("../utils/ensure_multi_turn");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createOutputApi(chatCompleteApi) {
  return function callOutputApi({
    id,
    connectorId,
    input,
    schema,
    system,
    previousMessages,
    modelName,
    functionCalling,
    stream,
    abortSignal,
    maxRetries,
    retryConfiguration,
    metadata,
    retry
  }) {
    if (stream && retry !== undefined) {
      throw new Error(`Retry options are not supported in streaming mode`);
    }
    const messages = (0, _ensure_multi_turn.ensureMultiTurn)([...(previousMessages || []), {
      role: _inferenceCommon.MessageRole.User,
      content: input
    }]);
    const response = chatCompleteApi({
      connectorId,
      stream,
      modelName,
      functionCalling,
      abortSignal,
      maxRetries,
      retryConfiguration,
      metadata,
      system,
      messages,
      ...(schema ? {
        tools: {
          structuredOutput: {
            description: `Use the following schema to respond to the user's request in structured data, so it can be parsed and handled.`,
            schema
          }
        },
        toolChoice: {
          function: 'structuredOutput'
        }
      } : {})
    });
    if ((0, _rxjs.isObservable)(response)) {
      return response.pipe((0, _inferenceCommon.withoutTokenCountEvents)(), (0, _rxjs.map)(event => {
        var _event$toolCalls, _event$toolCalls$, _event$toolCalls$2, _event$toolCalls$2$fu;
        if (event.type === _inferenceCommon.ChatCompletionEventType.ChatCompletionChunk) {
          return {
            type: _inferenceCommon.OutputEventType.OutputUpdate,
            id,
            content: event.content
          };
        }
        return {
          id,
          output: event !== null && event !== void 0 && (_event$toolCalls = event.toolCalls) !== null && _event$toolCalls !== void 0 && _event$toolCalls.length && 'arguments' in (event === null || event === void 0 ? void 0 : (_event$toolCalls$ = event.toolCalls[0]) === null || _event$toolCalls$ === void 0 ? void 0 : _event$toolCalls$.function) ? (_event$toolCalls$2 = event.toolCalls[0]) === null || _event$toolCalls$2 === void 0 ? void 0 : (_event$toolCalls$2$fu = _event$toolCalls$2.function) === null || _event$toolCalls$2$fu === void 0 ? void 0 : _event$toolCalls$2$fu.arguments : undefined,
          content: event.content,
          type: _inferenceCommon.OutputEventType.OutputComplete
        };
      }));
    } else {
      return response.then(chatResponse => {
        var _chatResponse$toolCal, _chatResponse$toolCal2, _chatResponse$toolCal3, _chatResponse$toolCal4;
        return {
          id,
          content: chatResponse.content,
          output: chatResponse !== null && chatResponse !== void 0 && (_chatResponse$toolCal = chatResponse.toolCalls) !== null && _chatResponse$toolCal !== void 0 && _chatResponse$toolCal.length && 'arguments' in (chatResponse === null || chatResponse === void 0 ? void 0 : (_chatResponse$toolCal2 = chatResponse.toolCalls[0]) === null || _chatResponse$toolCal2 === void 0 ? void 0 : _chatResponse$toolCal2.function) ? chatResponse === null || chatResponse === void 0 ? void 0 : (_chatResponse$toolCal3 = chatResponse.toolCalls[0]) === null || _chatResponse$toolCal3 === void 0 ? void 0 : (_chatResponse$toolCal4 = _chatResponse$toolCal3.function) === null || _chatResponse$toolCal4 === void 0 ? void 0 : _chatResponse$toolCal4.arguments : undefined
        };
      }, error => {
        if ((0, _inferenceCommon.isToolValidationError)(error) && retry !== null && retry !== void 0 && retry.onValidationError) {
          var _error$meta$toolCalls, _error$meta$toolCalls2;
          const retriesLeft = typeof retry.onValidationError === 'number' ? retry.onValidationError : 1;
          return callOutputApi({
            id,
            connectorId,
            input,
            schema,
            system,
            abortSignal,
            previousMessages: messages.concat({
              role: _inferenceCommon.MessageRole.Assistant,
              content: '',
              toolCalls: error.meta.toolCalls
            }, ...((_error$meta$toolCalls = (_error$meta$toolCalls2 = error.meta.toolCalls) === null || _error$meta$toolCalls2 === void 0 ? void 0 : _error$meta$toolCalls2.map(toolCall => {
              return {
                name: toolCall.function.name,
                role: _inferenceCommon.MessageRole.Tool,
                toolCallId: toolCall.toolCallId,
                response: {
                  error: error.meta
                }
              };
            })) !== null && _error$meta$toolCalls !== void 0 ? _error$meta$toolCalls : [])),
            functionCalling,
            modelName,
            stream: false,
            retry: {
              onValidationError: retriesLeft - 1
            }
          });
        }
        throw error;
      });
    }
  };
}