"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUiMetricServiceInstance = exports.getUiMetricServiceInstance = exports.UiMetricService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let uiMetricService;
class UiMetricService {
  constructor(appName) {
    (0, _defineProperty2.default)(this, "appName", void 0);
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
    this.appName = appName;
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  trackMetric(type, eventName) {
    if (!this.usageCollection) {
      // Usage collection might have been disabled in Kibana config.
      return;
    }
    return this.usageCollection.reportUiCounter(this.appName, type, eventName);
  }
}

/**
 * To minimize the refactor to migrate to NP where all deps should be explicitely declared
 * we will export here the instance created in our plugin.ts setup() so other parts of the code can access it.
 *
 * TODO: Refactor the api.ts (convert it to a class with setup()) and detail_panel.ts (reducer) to explicitely declare their dependency on the UiMetricService
 * @param instance UiMetricService instance from our plugin.ts setup()
 */
exports.UiMetricService = UiMetricService;
const setUiMetricServiceInstance = instance => {
  uiMetricService = instance;
};
exports.setUiMetricServiceInstance = setUiMetricServiceInstance;
const getUiMetricServiceInstance = () => {
  return uiMetricService;
};
exports.getUiMetricServiceInstance = getUiMetricServiceInstance;