"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelsDeploymentModal = TrainedModelsDeploymentModal;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _utils = require("../../../../components/mappings_editor/lib/utils");
var _lib = require("../../../../components/mappings_editor/lib");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_APP_LOCATOR = 'ML_APP_LOCATOR';
const TRAINED_MODELS_MANAGE = 'trained_models';
function TrainedModelsDeploymentModal({
  errorsInTrainedModelDeployment = {},
  forceSaveMappings,
  saveMappings,
  saveMappingsLoading,
  setErrorsInTrainedModelDeployment
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    fields,
    inferenceToModelIdMap
  } = (0, _mappings_state_context.useMappingsState)();
  const {
    url
  } = (0, _app_context.useAppContext)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const closeModal = () => setIsModalVisible(false);
  const [mlManagementPageUrl, setMlManagementPageUrl] = (0, _react.useState)('');
  const [allowForceSaveMappings, setAllowForceSaveMappings] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const mlLocator = url === null || url === void 0 ? void 0 : url.locators.get(ML_APP_LOCATOR);
    const generateUrl = async () => {
      if (mlLocator) {
        const mlURL = await mlLocator.getUrl({
          page: TRAINED_MODELS_MANAGE
        });
        setMlManagementPageUrl(mlURL);
      }
    };
    generateUrl();
  }, [url]);
  const inferenceIdsInPendingList = (0, _react.useMemo)(() => {
    return Object.values((0, _lib.deNormalize)(fields)).filter(_utils.isSemanticTextField).map(field => field.inference_id);
  }, [fields]);
  const [pendingDeployments, setPendingDeployments] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const models = inferenceIdsInPendingList.map(inferenceId => inferenceToModelIdMap !== null && inferenceToModelIdMap !== void 0 && inferenceToModelIdMap[inferenceId] ? {
      inferenceId,
      ...(inferenceToModelIdMap === null || inferenceToModelIdMap === void 0 ? void 0 : inferenceToModelIdMap[inferenceId])
    } : undefined); // filter out third-party models
    const allPendingDeployments = models.map(model => {
      return model !== null && model !== void 0 && model.trainedModelId && !(model !== null && model !== void 0 && model.isDeployed) ? model === null || model === void 0 ? void 0 : model.inferenceId : '';
    }).filter(id => !!id);
    const uniqueDeployments = allPendingDeployments.filter((deployment, index) => allPendingDeployments.indexOf(deployment) === index);
    setPendingDeployments(uniqueDeployments);
  }, [inferenceIdsInPendingList, inferenceToModelIdMap]);
  const erroredDeployments = pendingDeployments.filter(deployment => errorsInTrainedModelDeployment[deployment]);
  (0, _react.useEffect)(() => {
    if (erroredDeployments.length > 0 || pendingDeployments.length > 0) {
      setIsModalVisible(true);
    } else {
      setIsModalVisible(false);
    }
  }, [erroredDeployments.length, pendingDeployments.length]);
  return isModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    style: {
      width: 600
    },
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    "data-test-subj": "trainedModelsDeploymentModal",
    initialFocus: "[data-test-subj=tryAgainModalButton]"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    title: modalTitleId
  }, erroredDeployments.length > 0 ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.deploymentErrorTitle', {
    defaultMessage: 'Models could not be deployed'
  }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.titleLabel', {
    defaultMessage: 'Models still deploying'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "trainedModelsDeploymentModalText"
  }, erroredDeployments.length > 0 ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.deploymentErrorText', {
    defaultMessage: 'There was an error when trying to deploy the following models.'
  }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.textAboutDeploymentsNotCompleted', {
    defaultMessage: 'Some fields are referencing models that have not yet completed deployment. Deployment may take a few minutes to complete.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: mlManagementPageUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.textTrainedModelManagementLink', {
    defaultMessage: 'Go to Trained Model Management'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      listStyleType: 'none'
    }
  }, (erroredDeployments.length > 0 ? erroredDeployments : pendingDeployments).map(deployment => /*#__PURE__*/_react.default.createElement("li", {
    key: deployment
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger"
  }, deployment))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsConfirmLabel', {
      defaultMessage: 'Saving mappings without a deployed model may cause errors'
    })
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsDescription', {
    defaultMessage: 'Saving a semantic text field referencing a model that is not running will break ingesting documents and searching over documents using or referencing that field.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "allowForceSaveMappingsCheckbox",
    id: "allowForceSaveMappings",
    checked: allowForceSaveMappings,
    onChange: () => setAllowForceSaveMappings(!allowForceSaveMappings),
    label: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.allowForceSaveMappingsLabel', {
      defaultMessage: 'Allow semantic text mapping updates without a deployed model'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: saveMappings,
    "data-test-subj": "tryAgainModalButton",
    isLoading: saveMappingsLoading
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.tryAgainButtonLabel', {
    defaultMessage: 'Try again'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: forceSaveMappings,
    disabled: !allowForceSaveMappings,
    isLoading: saveMappingsLoading,
    "data-test-subj": "forceSaveMappingsButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsLabel', {
    defaultMessage: 'Force save mappings'
  })))))) : null;
}