"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../../../../../../common/constants");
var _shared_imports = require("../../../../../shared_imports");
var _use_json_step = require("./use_json_step");
var _shared_imports2 = require("../../../mappings_editor/shared_imports");
var _index_mode_labels = require("../../../../lib/index_mode_labels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The value of the number_of_shards setting that is allowed for lookup index mode
const NUMBER_OF_SHARDS_LOOKUP_MODE = 1;
const StepSettings = exports.StepSettings = /*#__PURE__*/_react.default.memo(({
  defaultValue = {},
  onChange,
  esDocsBase,
  indexMode
}) => {
  const {
    navigateToStep
  } = _shared_imports.Forms.useFormWizardContext();
  const customValidate = (0, _react.useCallback)(json => {
    var _settings$indexNumbe, _settings$index;
    if (!(0, _shared_imports.isJSON)(json)) return null;
    const settings = JSON.parse(json);
    const numberOfShardsValue = (_settings$indexNumbe = settings['index.number_of_shards']) !== null && _settings$indexNumbe !== void 0 ? _settings$indexNumbe : settings === null || settings === void 0 ? void 0 : (_settings$index = settings.index) === null || _settings$index === void 0 ? void 0 : _settings$index.number_of_shards;
    if (numberOfShardsValue != null && indexMode === _constants.LOOKUP_INDEX_MODE && (isNaN(numberOfShardsValue) || numberOfShardsValue !== NUMBER_OF_SHARDS_LOOKUP_MODE)) {
      return _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepSettings.validations.lookupIndexModeNumberOfShardsError', {
        defaultMessage: 'Number of shards for lookup index mode can only be 1 or unset.'
      });
    }
    return null;
  }, [indexMode]);
  const {
    jsonContent,
    setJsonContent,
    error
  } = (0, _use_json_step.useJsonStep)({
    defaultValue,
    onChange,
    customValidate
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "stepTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepSettings.stepTitle",
    defaultMessage: "Index settings (optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepSettings.settingsDescription",
    defaultMessage: "Define the behavior of your indices."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: _shared_imports2.documentationService.getSettingsDocumentationLink(),
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepSettings.docsButtonLabel",
    defaultMessage: "Index settings docs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), indexMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepSettings.indexModeCallout.title",
      defaultMessage: "The {settingName} setting has been set to {indexMode} within the {logisticsLink}. Any changes to {settingName} set on this page will be overwritten by the Logistics selection.",
      values: {
        settingName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepSettings.indexModeCallout.indexModeSettingLabel', {
          defaultMessage: 'index.mode'
        })),
        indexMode: _index_mode_labels.indexModeLabels[indexMode],
        logisticsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => navigateToStep(0)
        }, _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepSettings.indexModeCallout.logisticsLinkLabel', {
          defaultMessage: 'Logistics step'
        }))
      }
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "indexModeCallout"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepSettings.fieldIndexSettingsLabel",
      defaultMessage: "Index settings"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepSettings.settingsEditorHelpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, JSON.stringify({
          number_of_replicas: 1
        }))
      }
    }),
    isInvalid: Boolean(error),
    error: error,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: jsonContent,
    "data-test-subj": "settingsEditor",
    height: 500,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepSettings.fieldIndexSettingsAriaLabel', {
      defaultMessage: 'Index settings editor'
    }),
    onChange: setJsonContent
  })));
});