"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubobjectsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../services/documentation");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubobjectsSection = () => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.FormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsTitle', {
      defaultMessage: 'subobjects'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.subobjectsDescription",
      defaultMessage: "The {subobjectsParameter} setting, when set to {false}, disables the ability for an object to hold further subobjects and makes it possible to store documents where field names contain dots and share common prefixes. {docsLink}",
      values: {
        subobjectsParameter: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsParameterName', {
          defaultMessage: 'subobjects'
        })),
        false: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsParameterFalseValue', {
          defaultMessage: 'false'
        })),
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getSubobjectsLink(),
          target: "_blank"
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsDocumentionLink', {
          defaultMessage: 'Learn more.'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "subobjects",
    component: _shared_imports.ToggleField,
    componentProps: {
      'data-test-subj': 'subobjectsToggle'
    }
  }));
};
exports.SubobjectsSection = SubobjectsSection;