"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
var _component_templates_context = require("../component_templates_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = ({
  history
}) => {
  const {
    documentation
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    "data-test-subj": "emptyList",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "title"
    }, _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.emptyPromptTitle', {
      defaultMessage: 'Start by creating a component template'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.componentTemplates.emptyPromptDescription",
      defaultMessage: "For example, you can create a component template for index settings that can be reused across index templates."
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: documentation.componentTemplates,
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.emptyPromptDocumentionLink', {
      defaultMessage: 'Learn more.'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, '/create_component_template'), {
      iconType: "plusInCircle",
      fill: true
    }), _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.emptyPromptButtonLabel', {
      defaultMessage: 'Create a component template'
    }))
  });
};
exports.EmptyPrompt = EmptyPrompt;