"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _data_streams = require("../../../lib/data_streams");
var _component_templates_context = require("../component_templates_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFINITE_AS_ICON = true;
const TabSummary = ({
  componentTemplateDetails,
  showCallToAction
}) => {
  const {
    getUrlForApp
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    version,
    _meta,
    _kbnMeta,
    template
  } = componentTemplateDetails;
  const {
    usedBy
  } = _kbnMeta;
  const templateIsInUse = usedBy.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !templateIsInUse && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.notInUseTitle",
      defaultMessage: "This component template is not in use by any index templates."
    }),
    iconType: "pin",
    "data-test-subj": "notInUseCallout",
    size: "s"
  }, showCallToAction && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.notInUseDescription",
    defaultMessage: "{createLink} an index template or {editLink} an existing one.",
    values: {
      createLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getUrlForApp('management', {
          path: '/data/index_management/create_template'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.createTemplateLink",
        defaultMessage: "Create"
      })),
      editLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getUrlForApp('management', {
          path: '/data/index_management/templates'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.updateTemplateLink",
        defaultMessage: "update"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    "data-test-subj": "summaryTabContent"
  }, templateIsInUse && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "usedByTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.usedByDescriptionListTitle",
    defaultMessage: "Used by"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement("ul", null, usedBy.map(templateName => /*#__PURE__*/_react.default.createElement("li", {
    key: templateName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, templateName))))))), template.lifecycle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "dataRetentionTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.dataRetentionDescriptionListTitle",
    defaultMessage: "Data retention"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, (0, _data_streams.getLifecycleValue)(template.lifecycle, INFINITE_AS_ICON))), typeof version !== 'undefined' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "versionTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.versionDescriptionListTitle",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, version)), _meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.summaryTab.metaDescriptionListTitle",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(_meta, null, 2))))));
};
exports.TabSummary = TabSummary;