"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _policies = require("../../../lib/policies");
var _settings_local_storage = require("../../../lib/settings_local_storage");
var _shared_imports = require("../../../../shared_imports");
var _navigation = require("../../../services/navigation");
var _ui_metric = require("../../../services/ui_metric");
var _constants = require("../../../constants");
var _policy_list_context = require("../policy_list_context");
var _ = require(".");
var _use_is_read_only = require("../../../lib/use_is_read_only");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionTooltips = {
  viewIndices: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.viewIndicesButtonText', {
    defaultMessage: 'View indices linked to policy'
  }),
  viewIndexTemplates: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.viewIndexTemplatesButtonText', {
    defaultMessage: 'View index templates linked to policy'
  })
};
const SHOW_MANAGED_POLICIES_BY_DEFAULT = 'ILM_SHOW_MANAGED_POLICIES_BY_DEFAULT';
const PAGE_SIZE_OPTIONS = [10, 25, 50];
const PolicyTable = ({
  policies
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const isReadOnly = (0, _use_is_read_only.useIsReadOnly)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const [managedPoliciesVisible, setManagedPoliciesVisible] = (0, _settings_local_storage.useStateWithLocalStorage)(SHOW_MANAGED_POLICIES_BY_DEFAULT, false);
  const {
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'ilmPolicies',
    initialPageSize: 25,
    initialSort: {
      field: 'name',
      direction: 'asc'
    },
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const handleOnChange = ({
    queryText,
    error
  }) => {
    if (!error) {
      setQuery(queryText);
    }
  };
  const searchOptions = (0, _react.useMemo)(() => ({
    query,
    onChange: handleOnChange,
    box: {
      incremental: true,
      'data-test-subj': 'ilmSearchBar'
    },
    filters: [{
      type: 'is',
      field: 'policy.deprecated',
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.isDeprecatedFilterLabel', {
        defaultMessage: 'Deprecated'
      })
    }],
    toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: "checkboxShowHiddenIndices",
      "data-test-subj": "includeHiddenPoliciesSwitch",
      checked: managedPoliciesVisible,
      onChange: event => setManagedPoliciesVisible(event.target.checked),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.hiddenPoliciesSwitchLabel",
        defaultMessage: "Include managed system policies"
      })
    }))
  }), [managedPoliciesVisible, setManagedPoliciesVisible, query]);
  const filteredPolicies = (0, _react.useMemo)(() => {
    let result = managedPoliciesVisible ? policies : policies.filter(item => {
      var _item$policy, _item$policy$_meta;
      return !((_item$policy = item.policy) !== null && _item$policy !== void 0 && (_item$policy$_meta = _item$policy._meta) !== null && _item$policy$_meta !== void 0 && _item$policy$_meta.managed);
    });

    // When the query includes 'is:policy.deprecated', we want to show deprecated policies.
    // Otherwise hide them all since they wont be supported in the future.
    if (query.includes('is:policy.deprecated')) {
      result = result.filter(item => {
        var _item$policy2;
        return (_item$policy2 = item.policy) === null || _item$policy2 === void 0 ? void 0 : _item$policy2.deprecated;
      });
    } else {
      result = result.filter(item => {
        var _item$policy3;
        return !((_item$policy3 = item.policy) !== null && _item$policy3 !== void 0 && _item$policy3.deprecated);
      });
    }
    return result;
  }, [policies, managedPoliciesVisible, query]);
  const columns = [{
    'data-test-subj': 'policy-name',
    field: 'name',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.nameHeader', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (value, item) => {
      var _item$policy4, _item$policy4$_meta, _item$policy5;
      const isManaged = (_item$policy4 = item.policy) === null || _item$policy4 === void 0 ? void 0 : (_item$policy4$_meta = _item$policy4._meta) === null || _item$policy4$_meta === void 0 ? void 0 : _item$policy4$_meta.managed;
      const isDeprecated = (_item$policy5 = item.policy) === null || _item$policy5 === void 0 ? void 0 : _item$policy5.deprecated;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        className: "eui-textBreakAll",
        "data-test-subj": "policyTablePolicyNameLink"
      }, (0, _public.reactRouterNavigate)(history, (0, _navigation.getPolicyViewPath)(value), () => (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, _constants.UIM_VIEW_CLICK))), value), isDeprecated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_.DeprecatedPolicyBadge, null)), isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_.ManagedPolicyBadge, null)));
    }
  }, {
    'data-test-subj': 'policy-indexTemplates',
    field: 'indexTemplates',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.indexTemplatesHeader', {
      defaultMessage: 'Linked index templates'
    }),
    sortable: ({
      indexTemplates
    }) => (indexTemplates !== null && indexTemplates !== void 0 ? indexTemplates : []).length,
    render: (value, policy) => {
      return value && value.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: actionTooltips.viewIndexTemplates,
        position: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        flush: "both",
        "data-test-subj": "viewIndexTemplates",
        onClick: () => setListAction({
          selectedPolicy: policy,
          actionType: 'viewIndexTemplates'
        })
      }, value.length)) : '0';
    }
  }, {
    'data-test-subj': 'policy-indices',
    field: 'indices',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.linkedIndicesHeader', {
      defaultMessage: 'Linked indices'
    }),
    sortable: ({
      indices
    }) => (indices !== null && indices !== void 0 ? indices : []).length,
    render: (value, policy) => {
      return value && value.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: actionTooltips.viewIndices,
        position: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _navigation.getIndicesListPath)(policy.name, getUrlForApp)
      }, value.length)) : '0';
    }
  }, {
    'data-test-subj': 'policy-modifiedDate',
    field: 'modifiedDate',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.modifiedDateHeader', {
      defaultMessage: 'Modified date'
    }),
    sortable: true,
    render: value => {
      return value ? (0, _moment.default)(value).format('MMM D, YYYY') : value;
    }
  }];
  if (!isReadOnly) {
    columns.push({
      actions: [{
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.editActionLabel', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.editActionDescription', {
          defaultMessage: 'Edit this policy'
        }),
        type: 'icon',
        icon: 'pencil',
        onClick: ({
          name
        }) => history.push((0, _navigation.getPolicyEditPath)(name)),
        'data-test-subj': 'editPolicy'
      }, {
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addToIndexTemplateActionLabel', {
          defaultMessage: 'Add to index template'
        }),
        description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addToIndexTemplateActionDescription', {
          defaultMessage: 'Add policy to index template'
        }),
        type: 'icon',
        icon: 'plusInCircle',
        onClick: policy => setListAction({
          selectedPolicy: policy,
          actionType: 'addIndexTemplate'
        }),
        'data-test-subj': 'addPolicyToTemplate'
      }, {
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: policy => {
          return (0, _policies.hasLinkedIndices)(policy) ? _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.deletePolicyButtonDisabledTooltip', {
            defaultMessage: 'You cannot delete a policy that is being used by an index'
          }) : _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.deleteActionDescription', {
            defaultMessage: 'Delete this policy'
          });
        },
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: policy => setListAction({
          selectedPolicy: policy,
          actionType: 'deletePolicy'
        }),
        enabled: policy => !(0, _policies.hasLinkedIndices)(policy),
        'data-test-subj': 'deletePolicy'
      }],
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.actionsHeader', {
        defaultMessage: 'Actions'
      }),
      'data-test-subj': 'policyActionsCollapsedButton'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.captionText', {
      defaultMessage: 'The table below contains {count, plural, one {# Index Lifecycle policy} other {# Index Lifecycle policies}} .',
      values: {
        count: policies.length
      }
    }),
    pagination: {
      initialPageSize: pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    },
    onTableChange: onTableChange,
    sorting: sorting,
    search: searchOptions,
    tableLayout: "auto",
    items: filteredPolicies,
    columns: columns,
    rowProps: policy => ({
      'data-test-subj': `policyTableRow-${policy.name}`
    })
  });
};
exports.PolicyTable = PolicyTable;