"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDeserializer = void 0;
var _immer = require("immer");
var _policies = require("../../../lib/policies");
var _lib = require("../../../lib");
var _lib2 = require("../lib");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDeserializer = isCloudEnabled => policy => {
  var _hot$actions, _hot$actions2, _hot$actions2$forceme, _hot$actions3, _hot$actions$shrink, _hot$actions4, _warm$actions, _warm$actions$forceme, _warm$actions2, _warm$actions$shrink, _warm$actions3, _cold$actions, _cold$actions2;
  const {
    phases: {
      hot,
      warm,
      cold,
      frozen,
      delete: deletePhase
    }
  } = policy;
  let defaultRepository = (0, _lib2.getDefaultRepository)([hot === null || hot === void 0 ? void 0 : hot.actions.searchable_snapshot, cold === null || cold === void 0 ? void 0 : cold.actions.searchable_snapshot, frozen === null || frozen === void 0 ? void 0 : frozen.actions.searchable_snapshot]);
  if (!defaultRepository && isCloudEnabled) {
    defaultRepository = _constants.CLOUD_DEFAULT_REPO;
  }
  const _meta = {
    hot: {
      isUsingDefaultRollover: (0, _lib.isUsingDefaultRollover)(policy),
      customRollover: {
        enabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions = hot.actions) === null || _hot$actions === void 0 ? void 0 : _hot$actions.rollover)
      },
      bestCompression: (hot === null || hot === void 0 ? void 0 : (_hot$actions2 = hot.actions) === null || _hot$actions2 === void 0 ? void 0 : (_hot$actions2$forceme = _hot$actions2.forcemerge) === null || _hot$actions2$forceme === void 0 ? void 0 : _hot$actions2$forceme.index_codec) === 'best_compression',
      readonlyEnabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions3 = hot.actions) === null || _hot$actions3 === void 0 ? void 0 : _hot$actions3.readonly),
      shrink: {
        isUsingShardSize: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions$shrink = hot.actions.shrink) === null || _hot$actions$shrink === void 0 ? void 0 : _hot$actions$shrink.max_primary_shard_size)
      },
      downsample: {
        enabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions4 = hot.actions) === null || _hot$actions4 === void 0 ? void 0 : _hot$actions4.downsample)
      }
    },
    warm: {
      enabled: Boolean(warm),
      warmPhaseOnRollover: warm === undefined ? true : Boolean(warm.min_age === '0ms'),
      bestCompression: (warm === null || warm === void 0 ? void 0 : (_warm$actions = warm.actions) === null || _warm$actions === void 0 ? void 0 : (_warm$actions$forceme = _warm$actions.forcemerge) === null || _warm$actions$forceme === void 0 ? void 0 : _warm$actions$forceme.index_codec) === 'best_compression',
      dataTierAllocationType: (0, _lib.determineDataTierAllocationType)(warm === null || warm === void 0 ? void 0 : warm.actions),
      readonlyEnabled: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions2 = warm.actions) === null || _warm$actions2 === void 0 ? void 0 : _warm$actions2.readonly),
      minAgeToMilliSeconds: -1,
      shrink: {
        isUsingShardSize: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions$shrink = warm.actions.shrink) === null || _warm$actions$shrink === void 0 ? void 0 : _warm$actions$shrink.max_primary_shard_size)
      },
      downsample: {
        enabled: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions3 = warm.actions) === null || _warm$actions3 === void 0 ? void 0 : _warm$actions3.downsample)
      }
    },
    cold: {
      enabled: Boolean(cold),
      dataTierAllocationType: (0, _lib.determineDataTierAllocationType)(cold === null || cold === void 0 ? void 0 : cold.actions),
      readonlyEnabled: Boolean(cold === null || cold === void 0 ? void 0 : (_cold$actions = cold.actions) === null || _cold$actions === void 0 ? void 0 : _cold$actions.readonly),
      minAgeToMilliSeconds: -1,
      downsample: {
        enabled: Boolean(cold === null || cold === void 0 ? void 0 : (_cold$actions2 = cold.actions) === null || _cold$actions2 === void 0 ? void 0 : _cold$actions2.downsample)
      }
    },
    frozen: {
      enabled: Boolean(frozen),
      minAgeToMilliSeconds: -1
    },
    delete: {
      enabled: Boolean(deletePhase),
      minAgeToMilliSeconds: -1
    },
    searchableSnapshot: {
      repository: defaultRepository
    }
  };
  return (0, _immer.produce)({
    ...policy,
    _meta
  }, draft => {
    var _draft$phases$hot, _draft$phases$hot$act, _draft$phases$hot2, _draft$phases$hot2$ac, _draft$phases$hot3, _draft$phases$hot3$ac;
    if ((_draft$phases$hot = draft.phases.hot) !== null && _draft$phases$hot !== void 0 && (_draft$phases$hot$act = _draft$phases$hot.actions) !== null && _draft$phases$hot$act !== void 0 && _draft$phases$hot$act.rollover) {
      if (draft.phases.hot.actions.rollover.max_size) {
        const maxSize = (0, _policies.splitSizeAndUnits)(draft.phases.hot.actions.rollover.max_size);
        draft.phases.hot.actions.rollover.max_size = maxSize.size;
        draft._meta.hot.customRollover.maxStorageSizeUnit = maxSize.units;
      }
      if (draft.phases.hot.actions.rollover.max_primary_shard_size) {
        const maxPrimaryShardSize = (0, _policies.splitSizeAndUnits)(draft.phases.hot.actions.rollover.max_primary_shard_size);
        draft.phases.hot.actions.rollover.max_primary_shard_size = maxPrimaryShardSize.size;
        draft._meta.hot.customRollover.maxPrimaryShardSizeUnit = maxPrimaryShardSize.units;
      }
      if (draft.phases.hot.actions.rollover.max_age) {
        const maxAge = (0, _policies.splitSizeAndUnits)(draft.phases.hot.actions.rollover.max_age);
        draft.phases.hot.actions.rollover.max_age = maxAge.size;
        draft._meta.hot.customRollover.maxAgeUnit = maxAge.units;
      }
    }
    if ((_draft$phases$hot2 = draft.phases.hot) !== null && _draft$phases$hot2 !== void 0 && (_draft$phases$hot2$ac = _draft$phases$hot2.actions.shrink) !== null && _draft$phases$hot2$ac !== void 0 && _draft$phases$hot2$ac.max_primary_shard_size) {
      const primaryShardSize = (0, _policies.splitSizeAndUnits)(draft.phases.hot.actions.shrink.max_primary_shard_size);
      draft.phases.hot.actions.shrink.max_primary_shard_size = primaryShardSize.size;
      draft._meta.hot.shrink.maxPrimaryShardSizeUnits = primaryShardSize.units;
    }
    if ((_draft$phases$hot3 = draft.phases.hot) !== null && _draft$phases$hot3 !== void 0 && (_draft$phases$hot3$ac = _draft$phases$hot3.actions.downsample) !== null && _draft$phases$hot3$ac !== void 0 && _draft$phases$hot3$ac.fixed_interval) {
      const downsampleInterval = (0, _policies.splitSizeAndUnits)(draft.phases.hot.actions.downsample.fixed_interval);
      draft._meta.hot.downsample.fixedIntervalUnits = downsampleInterval.units;
      draft._meta.hot.downsample.fixedIntervalSize = downsampleInterval.size;
    }
    if (draft.phases.warm) {
      var _draft$phases$warm$ac, _draft$phases$warm$ac2, _draft$phases$warm$ac3, _draft$phases$warm, _draft$phases$warm$ac4;
      if ((_draft$phases$warm$ac = draft.phases.warm.actions) !== null && _draft$phases$warm$ac !== void 0 && (_draft$phases$warm$ac2 = _draft$phases$warm$ac.allocate) !== null && _draft$phases$warm$ac2 !== void 0 && _draft$phases$warm$ac2.require) {
        Object.entries(draft.phases.warm.actions.allocate.require).forEach(entry => {
          draft._meta.warm.allocationNodeAttribute = entry.join(':');
        });
      }
      if (draft.phases.warm.min_age) {
        const minAge = (0, _policies.splitSizeAndUnits)(draft.phases.warm.min_age);
        draft.phases.warm.min_age = minAge.size;
        draft._meta.warm.minAgeUnit = minAge.units;
      }
      if ((_draft$phases$warm$ac3 = draft.phases.warm.actions.shrink) !== null && _draft$phases$warm$ac3 !== void 0 && _draft$phases$warm$ac3.max_primary_shard_size) {
        const primaryShardSize = (0, _policies.splitSizeAndUnits)(draft.phases.warm.actions.shrink.max_primary_shard_size);
        draft.phases.warm.actions.shrink.max_primary_shard_size = primaryShardSize.size;
        draft._meta.warm.shrink.maxPrimaryShardSizeUnits = primaryShardSize.units;
      }
      if ((_draft$phases$warm = draft.phases.warm) !== null && _draft$phases$warm !== void 0 && (_draft$phases$warm$ac4 = _draft$phases$warm.actions.downsample) !== null && _draft$phases$warm$ac4 !== void 0 && _draft$phases$warm$ac4.fixed_interval) {
        const downsampleInterval = (0, _policies.splitSizeAndUnits)(draft.phases.warm.actions.downsample.fixed_interval);
        draft._meta.warm.downsample.fixedIntervalUnits = downsampleInterval.units;
        draft._meta.warm.downsample.fixedIntervalSize = downsampleInterval.size;
      }
    }
    if (draft.phases.cold) {
      var _draft$phases$cold$ac, _draft$phases$cold$ac2, _draft$phases$cold, _draft$phases$cold$ac3;
      if ((_draft$phases$cold$ac = draft.phases.cold.actions) !== null && _draft$phases$cold$ac !== void 0 && (_draft$phases$cold$ac2 = _draft$phases$cold$ac.allocate) !== null && _draft$phases$cold$ac2 !== void 0 && _draft$phases$cold$ac2.require) {
        Object.entries(draft.phases.cold.actions.allocate.require).forEach(entry => {
          draft._meta.cold.allocationNodeAttribute = entry.join(':');
        });
      }
      if (draft.phases.cold.min_age) {
        const minAge = (0, _policies.splitSizeAndUnits)(draft.phases.cold.min_age);
        draft.phases.cold.min_age = minAge.size;
        draft._meta.cold.minAgeUnit = minAge.units;
      }
      if ((_draft$phases$cold = draft.phases.cold) !== null && _draft$phases$cold !== void 0 && (_draft$phases$cold$ac3 = _draft$phases$cold.actions.downsample) !== null && _draft$phases$cold$ac3 !== void 0 && _draft$phases$cold$ac3.fixed_interval) {
        const downsampleInterval = (0, _policies.splitSizeAndUnits)(draft.phases.cold.actions.downsample.fixed_interval);
        draft._meta.cold.downsample.fixedIntervalUnits = downsampleInterval.units;
        draft._meta.cold.downsample.fixedIntervalSize = downsampleInterval.size;
      }
    }
    if (draft.phases.frozen) {
      if (draft.phases.frozen.min_age) {
        const minAge = (0, _policies.splitSizeAndUnits)(draft.phases.frozen.min_age);
        draft.phases.frozen.min_age = minAge.size;
        draft._meta.frozen.minAgeUnit = minAge.units;
      }
    }
    if (draft.phases.delete) {
      if (draft.phases.delete.min_age) {
        const minAge = (0, _policies.splitSizeAndUnits)(draft.phases.delete.min_age);
        draft.phases.delete.min_age = minAge.size;
        draft._meta.delete.minAgeUnit = minAge.units;
      }
    }
  });
};
exports.createDeserializer = createDeserializer;