"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _form = require("../../../form");
var _shared_fields = require("../shared_fields");
require("./phase_title.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PhaseTitle = ({
  phase
}) => {
  const enabledPath = `_meta.${phase}.enabled`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [enabledPath]
  });
  const isHotPhase = phase === 'hot';
  const isDeletePhase = phase === 'delete';
  const {
    setDeletePhaseEnabled
  } = (0, _form.usePhaseTimings)();
  // hot phase is always enabled
  const enabled = (0, _lodash.get)(formData, enabledPath) || isHotPhase;
  const {
    errors
  } = (0, _form.useFormErrorsContext)();
  const hasErrors = Object.keys(errors[phase]).length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, !isHotPhase && !isDeletePhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: enabledPath,
    component: _shared_imports.ToggleField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': `enablePhaseSwitch-${phase}`,
        showLabel: false
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "ilmPhaseTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n_texts.i18nTexts.editPolicy.titles[phase]))), isHotPhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "ilmPhaseRequiredBadge"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.phaseTitle.requiredBadge",
    defaultMessage: "Required"
  }))), isDeletePhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setDeletePhaseEnabled(false),
    "data-test-subj": 'disableDeletePhaseButton'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.removeDeletePhaseButtonLabel",
    defaultMessage: "Remove"
  }))), hasErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `phaseErrorIndicator-${phase}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "danger",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.phaseErrorIcon.tooltipDescription",
      defaultMessage: "This phase contains errors."
    })
  })))), !isHotPhase && enabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_fields.MinAgeField, {
    phase: phase
  })));
};
exports.PhaseTitle = PhaseTitle;