"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _solution_panel = require("./solution_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sortByOrder = ({
  order: orderA = 0
}, {
  order: orderB = 0
}) => orderA - orderB;
const SolutionsSection = ({
  addBasePath,
  solutions
}) => {
  if (solutions.length) {
    solutions = solutions.sort(sortByOrder);
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      "aria-labelledby": "homSolutions__title",
      className: "homSolutions",
      contentProps: {
        className: 'homSolutions__content'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homSolutions__title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.solutionsSection.sectionTitle",
      defaultMessage: "Pick your solution"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: "homSolutions__content"
    }, solutions.map(solution => /*#__PURE__*/_react.default.createElement(_solution_panel.SolutionPanel, {
      addBasePath: addBasePath,
      key: solution.id,
      solution: solution
    }))));
  } else {
    return null;
  }
};
exports.SolutionsSection = SolutionsSection;