"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidePanelFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _guide_panel_flyout_header = require("./guide_panel_flyout_header");
var _guide_panel_flyout_body = require("./guide_panel_flyout_body");
var _guide_panel_flyout_footer = require("./guide_panel_flyout_footer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const GuidePanelFlyout = ({
  isOpen,
  isDarkTheme,
  toggleGuide,
  isGuideReadyToComplete,
  guideConfig,
  styles,
  navigateToLandingPage,
  stepsCompleted,
  pluginState,
  handleStepButtonClick,
  isLoading,
  euiTheme,
  openQuitGuideModal,
  completeGuide
}) => {
  if (!isOpen) {
    return null;
  }
  const guidePanelFlyoutTitleId = 'onboarding-guide';
  const backToGuidesButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: navigateToLandingPage,
    iconSide: "left",
    iconType: "arrowLeft",
    flush: "left",
    color: "text"
  }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.backToGuidesLink', {
    defaultMessage: 'Back to guides'
  }));
  const hasError = !guideConfig || !pluginState || pluginState && pluginState.status === 'error';
  const {
    flyoutContentWrapper,
    flyoutBody,
    flyoutBodyWrapper,
    flyoutContainerError,
    flyoutContainer
  } = styles.flyoutOverrides;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    onClickOutside: toggleGuide
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "guidePanel",
    "aria-labelledby": guidePanelFlyoutTitleId,
    role: "dialog",
    css: hasError ? flyoutContainerError : flyoutContainer
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: flyoutContentWrapper
  }, /*#__PURE__*/_react.default.createElement(_guide_panel_flyout_header.GuidePanelFlyoutHeader, {
    styles: styles,
    titleId: guidePanelFlyoutTitleId,
    toggleGuide: toggleGuide,
    guideConfig: guideConfig,
    isGuideReadyToComplete: isGuideReadyToComplete,
    backButton: backToGuidesButton,
    hasError: hasError
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: flyoutBodyWrapper
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: flyoutBody
  }, /*#__PURE__*/_react.default.createElement(_guide_panel_flyout_body.GuidePanelFlyoutBody, {
    styles: styles,
    guideConfig: guideConfig,
    pluginState: pluginState,
    handleStepButtonClick: handleStepButtonClick,
    isLoading: isLoading,
    isDarkTheme: isDarkTheme,
    stepsCompleted: stepsCompleted,
    isGuideReadyToComplete: isGuideReadyToComplete,
    completeGuide: completeGuide
  }))), !hasError && /*#__PURE__*/_react.default.createElement(_guide_panel_flyout_footer.GuidePanelFlyoutFooter, {
    styles: styles,
    euiTheme: euiTheme,
    openQuitGuideModal: openQuitGuideModal
  }))))));
};
exports.GuidePanelFlyout = GuidePanelFlyout;