"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokDebuggerComponent = exports.GrokDebugger = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _isEmpty = _interopRequireDefault(require("lodash/isEmpty"));
var _eui = require("@elastic/eui");
var _event_input = require("../event_input");
var _pattern_input = require("../pattern_input");
var _custom_patterns_input = require("../custom_patterns_input");
var _event_output = require("../event_output");
var _grokdebugger_request = require("../../models/grokdebugger_request");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Prefer importing entire lodash library, e.g. import { get } from "lodash"
// eslint-disable-next-line no-restricted-imports

const i18nTexts = {
  simulate: {
    errorTitle: _i18n.i18n.translate('xpack.grokDebugger.simulate.errorTitle', {
      defaultMessage: 'Simulate error'
    }),
    unknownErrorTitle: _i18n.i18n.translate('xpack.grokDebugger.unknownErrorTitle', {
      defaultMessage: 'Something went wrong'
    })
  }
};
class GrokDebuggerComponent extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onRawEventChange", rawEvent => {
      this.setState({
        rawEvent
      });
      this.grokdebuggerRequest.rawEvent = rawEvent.trimEnd();
    });
    (0, _defineProperty2.default)(this, "onPatternChange", pattern => {
      this.setState({
        pattern
      });
      this.grokdebuggerRequest.pattern = pattern.trimEnd();
    });
    (0, _defineProperty2.default)(this, "onCustomPatternsChange", customPatterns => {
      this.setState({
        customPatterns
      });
      customPatterns = customPatterns.trim();
      const customPatternsObj = {};
      if (!customPatterns) {
        this.grokdebuggerRequest.customPatterns = customPatternsObj;
        return;
      }
      customPatterns.split('\n').forEach(customPattern => {
        // Patterns are defined like so:
        // patternName patternDefinition
        // For example:
        // POSTGRESQL %{DATESTAMP:timestamp} %{TZ} %{DATA:user_id} %{GREEDYDATA:connection_id} %{POSINT:pid}
        const [, patternName, patternDefinition] = customPattern.match(/(\S+)\s+(.+)/) || [];
        if (patternName && patternDefinition) {
          customPatternsObj[patternName] = patternDefinition;
        }
      });
      this.grokdebuggerRequest.customPatterns = customPatternsObj;
    });
    (0, _defineProperty2.default)(this, "simulateGrok", async () => {
      const notifications = this.props.kibana.services.notifications;
      try {
        const simulateResponse = await this.props.grokdebuggerService.simulate(this.grokdebuggerRequest);
        this.setState({
          structuredEvent: simulateResponse.structuredEvent
        });
        if (!(0, _isEmpty.default)(simulateResponse.error)) {
          notifications.toasts.addDanger({
            title: i18nTexts.simulate.errorTitle,
            text: simulateResponse.error
          });
        }
      } catch (e) {
        notifications.toasts.addError(e, {
          title: i18nTexts.simulate.unknownErrorTitle
        });
      }
    });
    (0, _defineProperty2.default)(this, "onSimulateClick", () => {
      this.setState({
        structuredEvent: {}
      }, this.simulateGrok);
    });
    (0, _defineProperty2.default)(this, "isSimulateDisabled", () => {
      return this.state.rawEvent.trim() === '' || this.state.pattern.trim() === '';
    });
    this.state = {
      rawEvent: '',
      pattern: '',
      customPatterns: '',
      structuredEvent: {}
    };
    this.grokdebuggerRequest = new _grokdebugger_request.GrokdebuggerRequest();
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      grow: true,
      color: "plain"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      className: "grokdebugger-container",
      "data-test-subj": "grokDebuggerContainer"
    }, /*#__PURE__*/_react.default.createElement(_event_input.EventInput, {
      value: this.state.rawEvent,
      onChange: this.onRawEventChange
    }), /*#__PURE__*/_react.default.createElement(_pattern_input.PatternInput, {
      value: this.state.pattern,
      onChange: this.onPatternChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_custom_patterns_input.CustomPatternsInput, {
      value: this.state.customPatterns,
      onChange: this.onCustomPatternsChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.onSimulateClick,
      isDisabled: this.isSimulateDisabled(),
      "data-test-subj": "btnSimulate"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.grokDebugger.simulateButtonLabel",
      defaultMessage: "Simulate"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_event_output.EventOutput, {
      value: this.state.structuredEvent
    })))));
  }
}
exports.GrokDebuggerComponent = GrokDebuggerComponent;
const GrokDebugger = exports.GrokDebugger = (0, _public.withKibana)(GrokDebuggerComponent);