"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _license_state = require("./lib/license_state");
var _search = require("./routes/search");
var _explore = require("./routes/explore");
var _sample_data = require("./sample_data");
var _saved_objects = require("./saved_objects");
var _content_management = require("../common/content_management");
var _graph_storage = require("./content_management/graph_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GraphPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "licenseState", null);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    licensing,
    home,
    features,
    contentManagement
  }) {
    const licenseState = new _license_state.LicenseState();
    licenseState.start(licensing.license$);
    this.licenseState = licenseState;
    core.savedObjects.registerType(_saved_objects.graphWorkspace);
    licensing.featureUsage.register('Graph', 'platinum');
    contentManagement.register({
      id: _content_management.CONTENT_ID,
      storage: new _graph_storage.GraphStorage({
        throwOnResultValidationError: this.initializerContext.env.mode.dev,
        logger: this.initializerContext.logger.get()
      }),
      version: {
        latest: _content_management.LATEST_VERSION
      }
    });
    if (home) {
      (0, _sample_data.registerSampleData)(home.sampleData, licenseState);
    }
    if (features) {
      features.registerKibanaFeature({
        id: 'graph',
        name: _i18n.i18n.translate('xpack.graph.featureRegistry.graphFeatureName', {
          defaultMessage: 'Graph'
        }),
        order: 600,
        category: _server.DEFAULT_APP_CATEGORIES.kibana,
        scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
        app: ['graph', 'kibana'],
        catalogue: ['graph'],
        minimumLicense: 'platinum',
        privileges: {
          all: {
            app: ['graph', 'kibana'],
            catalogue: ['graph'],
            savedObject: {
              all: ['graph-workspace'],
              read: ['index-pattern']
            },
            ui: ['save', 'delete', 'show']
          },
          read: {
            app: ['graph', 'kibana'],
            catalogue: ['graph'],
            savedObject: {
              all: [],
              read: ['index-pattern', 'graph-workspace']
            },
            ui: ['show']
          }
        }
      });
    }
    const router = core.http.createRouter();
    (0, _search.registerSearchRoute)({
      licenseState,
      router
    });
    (0, _explore.registerExploreRoute)({
      licenseState,
      router
    });
  }
  start(core, {
    licensing
  }) {
    this.licenseState.setNotifyUsage(licensing.featureUsage.notifyUsage);
  }
  stop() {
    if (this.licenseState) {
      this.licenseState.stop();
    }
  }
}
exports.GraphPlugin = GraphPlugin;