"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = void 0;
exports.SettingsComponent = SettingsComponent;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _advanced_settings_form = require("./advanced_settings_form");
var _blocklist_form = require("./blocklist_form");
var _url_template_list = require("./url_template_list");
var _state_management = require("../../state_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: 'advancedSettings',
  title: _i18n.i18n.translate('xpack.graph.settings.advancedSettingsTitle', {
    defaultMessage: 'Advanced settings'
  }),
  component: _advanced_settings_form.AdvancedSettingsForm
}, {
  id: 'blocklist',
  title: _i18n.i18n.translate('xpack.graph.settings.blocklistTitle', {
    defaultMessage: 'Hidden list'
  }),
  component: _blocklist_form.BlocklistForm
}, {
  id: 'drillDowns',
  title: _i18n.i18n.translate('xpack.graph.settings.drillDownsTitle', {
    defaultMessage: 'Drilldowns'
  }),
  component: _url_template_list.UrlTemplateList
}];
function SettingsComponent({
  observable,
  advancedSettings,
  urlTemplates,
  allFields,
  saveTemplate: saveTemplateAction,
  updateSettings: updateSettingsAction,
  removeTemplate: removeTemplateAction
}) {
  const [workspaceProps, setWorkspaceProps] = (0, _react.useState)(undefined);
  const [activeTab, setActiveTab] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    observable.subscribe(setWorkspaceProps);
  }, [observable]);
  if (!workspaceProps) {
    return null;
  }
  const ActiveTabContent = tabs[activeTab].component;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.graph.settings.title', {
    defaultMessage: 'Settings'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      margin: '0 -16px -25px'
    }
  }, tabs.filter(({
    id
  }) => id !== 'drillDowns' || workspaceProps.canEditDrillDownUrls).map(({
    title,
    id
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: title,
    isSelected: activeTab === index,
    "data-test-subj": id,
    onClick: () => {
      setActiveTab(index);
    }
  }, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(ActiveTabContent, {
    blocklistedNodes: workspaceProps.blocklistedNodes,
    unblockNode: workspaceProps.unblockNode,
    unblockAll: workspaceProps.unblockAll,
    advancedSettings: advancedSettings,
    urlTemplates: urlTemplates,
    allFields: allFields,
    updateSettings: updateSettingsAction,
    removeTemplate: removeTemplateAction,
    saveTemplate: saveTemplateAction
  })));
}
const Settings = exports.Settings = (0, _reactRedux.connect)(state => ({
  advancedSettings: (0, _state_management.settingsSelector)(state),
  urlTemplates: (0, _state_management.templatesSelector)(state),
  allFields: (0, _state_management.fieldsSelector)(state)
}), dispatch => (0, _redux.bindActionCreators)({
  updateSettings: _state_management.updateSettings,
  saveTemplate: _state_management.saveTemplate,
  removeTemplate: _state_management.removeTemplate
}, dispatch))(SettingsComponent);