"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePackagePoliciesRequestSchema = exports.UpdatePackagePolicyRequestSchema = exports.GetPackagePoliciesRequestSchema = exports.GetOnePackagePolicyRequestSchema = exports.DryRunPackagePoliciesRequestSchema = exports.DeletePackagePoliciesRequestSchema = exports.DeleteOnePackagePolicyRequestSchema = exports.CreatePackagePolicyRequestSchema = exports.BulkGetPackagePoliciesRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _filter_utils = require("../../routes/utils/filter_utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetPackagePoliciesRequestSchema = exports.GetPackagePoliciesRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20
    })),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('desc'), _configSchema.schema.literal('asc')])),
    showUpgradeable: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants2.PACKAGE_POLICY_SAVED_OBJECT_TYPE], _constants2.PACKAGE_POLICIES_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    })),
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)])),
    withAgentCount: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const BulkGetPackagePoliciesRequestSchema = exports.BulkGetPackagePoliciesRequestSchema = {
  body: _common.BulkRequestBodySchema,
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const GetOnePackagePolicyRequestSchema = exports.GetOnePackagePolicyRequestSchema = {
  params: _configSchema.schema.object({
    packagePolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const CreatePackagePolicyRequestSchema = exports.CreatePackagePolicyRequestSchema = {
  body: _configSchema.schema.oneOf([_models.CreatePackagePolicyRequestBodySchema, _models.SimplifiedCreatePackagePolicyRequestBodySchema]),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const UpdatePackagePolicyRequestSchema = exports.UpdatePackagePolicyRequestSchema = {
  ...GetOnePackagePolicyRequestSchema,
  body: _configSchema.schema.oneOf([_models.UpdatePackagePolicyRequestBodySchema, _models.SimplifiedCreatePackagePolicyRequestBodySchema]),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const DeletePackagePoliciesRequestSchema = exports.DeletePackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const DeleteOnePackagePolicyRequestSchema = exports.DeleteOnePackagePolicyRequestSchema = {
  params: _configSchema.schema.object({
    packagePolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const UpgradePackagePoliciesRequestSchema = exports.UpgradePackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
  })
};
const DryRunPackagePoliciesRequestSchema = exports.DryRunPackagePoliciesRequestSchema = {
  body: _configSchema.schema.object({
    packagePolicyIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    packageVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};