"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyPackageBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _hooks = require("../hooks");
var _agent_policy_package_badge = require("./agent_policy_package_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyPackageBadges = ({
  agentPolicyId,
  hideTitle,
  excludeFleetServer
}) => {
  const agentPolicyRequest = (0, _hooks.useGetOneAgentPolicy)(agentPolicyId);
  const agentPolicy = agentPolicyRequest.data ? agentPolicyRequest.data.item : null;
  const packages = (0, _react.useMemo)(() => {
    if (!agentPolicy) {
      return;
    }
    const uniquePackages = new Map();
    agentPolicy.package_policies.forEach(({
      package: pkg
    }) => {
      if (!pkg) {
        return;
      }
      if (!uniquePackages.has(pkg.name) || uniquePackages.get(pkg.name).version < pkg.version) {
        uniquePackages.set(pkg.name, pkg);
      }
    });
    return [...uniquePackages.values()];
  }, [agentPolicy]);
  const showFleetServerWarning = (0, _react.useMemo)(() => excludeFleetServer && (packages === null || packages === void 0 ? void 0 : packages.some(pkg => pkg.name === _constants.FLEET_SERVER_PACKAGE)), [packages, excludeFleetServer]);
  const collectedIntegrationsCount = (0, _react.useMemo)(() => packages ? packages.filter(pkg => !excludeFleetServer || pkg.name !== _constants.FLEET_SERVER_PACKAGE).length : 0, [packages, excludeFleetServer]);
  if (!agentPolicy || !packages) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentReassignPolicy.policyDescription",
    defaultMessage: "The selected agent policy will collect data for {count, plural, one {{countValue} integration} other {{countValue} integrations}}:",
    values: {
      count: collectedIntegrationsCount,
      countValue: /*#__PURE__*/_react.default.createElement("b", null, collectedIntegrationsCount)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center",
    wrap: true
  }, packages.map((pkg, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_agent_policy_package_badge.AgentPolicyPackageBadge, {
      key: idx,
      excludeFleetServer: excludeFleetServer,
      pkgName: pkg.name,
      pkgVersion: pkg.version,
      pkgTitle: pkg.title
    }));
  })), showFleetServerWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.fleet.agentReassignPolicy.packageBadgeFleetServerWarning', {
      defaultMessage: 'Fleet Server will not be enabled in standalone mode.'
    })
  })));
};
exports.AgentPolicyPackageBadges = AgentPolicyPackageBadges;