"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Details = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/custom-integrations-plugin/public");
var _lodash = require("lodash");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../constants");
var _changelog_modal = require("../settings/changelog_modal");
var _notice_modal = require("./notice_modal");
var _license_modal = require("./license_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReplacementCard = (0, _public.withSuspense)(_public.LazyReplacementCard);
const Replacements = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  margin: 0;

  & .euiAccordion {
    padding-top: ${({
  theme
}) => parseInt(theme.eui.euiSizeL, 10) * 2}px;

    &::before {
      content: '';
      display: block;
      border-top: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
      position: relative;
      top: -${({
  theme
}) => theme.eui.euiSizeL};
      margin: 0 ${({
  theme
}) => theme.eui.euiSizeXS};
    }
  }
`;
const Details = exports.Details = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  integrationInfo
}) => {
  var _packageInfo$conditio3, _packageInfo$conditio4, _packageInfo$source4, _packageInfo$source5;
  const config = (0, _hooks.useConfig)();
  const {
    data: categoriesData,
    isLoading: isLoadingCategories
  } = (0, _hooks.useGetCategoriesQuery)();
  const mergedCategories = (0, _react.useMemo)(() => {
    let allCategories = [];
    if (packageInfo !== null && packageInfo !== void 0 && packageInfo.categories) {
      allCategories = packageInfo.categories;
    }
    if (integrationInfo !== null && integrationInfo !== void 0 && integrationInfo.categories) {
      allCategories = (0, _lodash.uniq)([...allCategories, ...((integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.categories) || [])]);
    }
    return allCategories;
  }, [integrationInfo, packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.categories]);
  const packageCategories = (0, _react.useMemo)(() => {
    if (!isLoadingCategories && categoriesData !== null && categoriesData !== void 0 && categoriesData.items) {
      return categoriesData.items.filter(category => mergedCategories === null || mergedCategories === void 0 ? void 0 : mergedCategories.includes(category.id)).map(category => category.title);
    }
    return [];
  }, [categoriesData, isLoadingCategories, mergedCategories]);
  const [isNoticeModalOpen, setIsNoticeModalOpen] = (0, _react.useState)(false);
  const toggleNoticeModal = (0, _react.useCallback)(() => {
    setIsNoticeModalOpen(currentState => !currentState);
  }, []);
  const [isLicenseModalOpen, setIsLicenseModalOpen] = (0, _react.useState)(false);
  const toggleLicenseModal = (0, _react.useCallback)(() => {
    setIsLicenseModalOpen(currentState => !currentState);
  }, []);
  const [isChangelogModalOpen, setIsChangelogModalOpen] = (0, _react.useState)(false);
  const toggleChangelogModal = (0, _react.useCallback)(() => {
    setIsChangelogModalOpen(currentState => !currentState);
  }, []);
  const listItems = (0, _react.useMemo)(() => {
    var _packageInfo$data_str, _packageInfo$conditio, _packageInfo$conditio2, _packageInfo$source;
    // Base details: version and categories
    const items = [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.versionLabel",
        defaultMessage: "Version"
      })),
      description: packageInfo.version
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.categoryLabel",
        defaultMessage: "Category"
      })),
      description: packageCategories.join(', ')
    }];

    // Asset details and counts
    (0, _types.entries)(packageInfo.assets).forEach(([service, typeToParts]) => {
      // Filter out assets we are not going to display
      // (currently we only display Kibana and Elasticsearch assets)
      // and filter out dashboard references if configured
      const filteredTypes = (0, _types.entries)(typeToParts).reduce((acc, [asset, value]) => {
        if (_constants.DisplayedAssetsFromPackageInfo[service].includes(asset) && (!(config !== null && config !== void 0 && config.hideDashboards) || asset !== 'dashboard')) {
          acc[asset] = value;
        }
        return acc;
      }, {});
      if (Object.entries(filteredTypes).length) {
        items.push({
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "subdued"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epm.assetGroupTitle",
            defaultMessage: "{assetType} assets",
            values: {
              assetType: _constants.ServiceTitleMap[service]
            }
          })),
          description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            direction: "column",
            gutterSize: "xs"
          }, (0, _types.entries)(filteredTypes).map(([_type, parts], index) => {
            const type = _type;
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              key: `item-${index}`
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
              gutterSize: "xs",
              alignItems: "center",
              justifyContent: "spaceBetween"
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false
            }, _constants.AssetTitleMap[type]), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
              color: "subdued"
            }, parts.length))));
          }))
        });
      }
    });

    // Feature (data stream type) details
    const dataStreamTypes = [...new Set(((_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.map(dataStream => dataStream.type)) || [])];
    if (dataStreamTypes.length) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.featuresLabel",
          defaultMessage: "Features"
        })),
        description: dataStreamTypes.join(', ')
      });
    }

    // Subscription details
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.subscriptionLabel",
        defaultMessage: "Subscription"
      })),
      description: /*#__PURE__*/_react.default.createElement("p", null, ((_packageInfo$conditio = packageInfo.conditions) === null || _packageInfo$conditio === void 0 ? void 0 : (_packageInfo$conditio2 = _packageInfo$conditio.elastic) === null || _packageInfo$conditio2 === void 0 ? void 0 : _packageInfo$conditio2.subscription) || packageInfo.license || '-')
    });
    let ownerTypeDescription;
    switch (packageInfo.owner.type) {
      case 'community':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeCommunityDescription",
          defaultMessage: "Community"
        });
        break;
      case 'partner':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypePartnerDescription",
          defaultMessage: "Partner"
        });
        break;
      case 'elastic':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeElasticDescription",
          defaultMessage: "Elastic"
        });
        break;
    }
    if (ownerTypeDescription) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeLabel",
          defaultMessage: "Developed by"
        })),
        description: ownerTypeDescription
      });
    }

    // License details
    if (packageInfo.licensePath || (_packageInfo$source = packageInfo.source) !== null && _packageInfo$source !== void 0 && _packageInfo$source.license || packageInfo.notice) {
      var _packageInfo$source2, _packageInfo$source3;
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.licenseLabel",
          defaultMessage: "License"
        })),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, packageInfo.licensePath ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleLicenseModal
        }, ((_packageInfo$source2 = packageInfo.source) === null || _packageInfo$source2 === void 0 ? void 0 : _packageInfo$source2.license) || 'LICENSE.txt')) : /*#__PURE__*/_react.default.createElement("p", null, ((_packageInfo$source3 = packageInfo.source) === null || _packageInfo$source3 === void 0 ? void 0 : _packageInfo$source3.license) || '-'), packageInfo.notice && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleNoticeModal
        }, "NOTICE.txt")))
      });
    }
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.changelogLabel",
        defaultMessage: "Changelog"
      })),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: toggleChangelogModal
      }, "View Changelog")))
    });
    return items;
  }, [packageCategories, packageInfo.assets, (_packageInfo$conditio3 = packageInfo.conditions) === null || _packageInfo$conditio3 === void 0 ? void 0 : (_packageInfo$conditio4 = _packageInfo$conditio3.elastic) === null || _packageInfo$conditio4 === void 0 ? void 0 : _packageInfo$conditio4.subscription, packageInfo.data_streams, packageInfo.license, packageInfo.licensePath, packageInfo.notice, (_packageInfo$source4 = packageInfo.source) === null || _packageInfo$source4 === void 0 ? void 0 : _packageInfo$source4.license, packageInfo.owner.type, packageInfo.version, config === null || config === void 0 ? void 0 : config.hideDashboards, toggleLicenseModal, toggleNoticeModal, toggleChangelogModal]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, isNoticeModalOpen && packageInfo.notice && /*#__PURE__*/_react.default.createElement(_notice_modal.NoticeModal, {
    noticePath: packageInfo.notice,
    onClose: toggleNoticeModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, isLicenseModalOpen && packageInfo.licensePath && /*#__PURE__*/_react.default.createElement(_license_modal.LicenseModal, {
    licenseName: (_packageInfo$source5 = packageInfo.source) === null || _packageInfo$source5 === void 0 ? void 0 : _packageInfo$source5.license,
    licensePath: packageInfo.licensePath,
    onClose: toggleLicenseModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, isChangelogModalOpen && /*#__PURE__*/_react.default.createElement(_changelog_modal.ChangelogModal, {
    latestVersion: packageInfo.version,
    packageName: packageInfo.name,
    onClose: toggleChangelogModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.detailsTitle",
    defaultMessage: "Details"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    listItems: listItems
  })), /*#__PURE__*/_react.default.createElement(Replacements, null, /*#__PURE__*/_react.default.createElement(ReplacementCard, {
    eprPackageName: packageInfo.name
  }))));
});