"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextInput = exports.TextAreaInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextInput = ({
  label,
  inputProps,
  placeholder,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
  fullWidth: true,
  label: label
}, inputProps.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": dataTestSubj,
  fullWidth: true
}, inputProps.props, {
  placeholder: placeholder
})));
exports.TextInput = TextInput;
const TextAreaInput = ({
  label,
  inputProps,
  placeholder,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
  fullWidth: true,
  label: label
}, inputProps.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
  fullWidth: true,
  rows: 5,
  "data-test-subj": dataTestSubj
}, inputProps.props, {
  placeholder: placeholder
})));
exports.TextAreaInput = TextAreaInput;