"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryClient = exports.DebugPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Evaluate moving this react-query initialization up to the main Fleet app
// setup if we end up pursuing wider adoption of react-query.
const queryClient = exports.queryClient = new _reactQuery.QueryClient();
const panels = [{
  title: _i18n.i18n.translate('xpack.fleet.debug.HealthCheckStatus.title', {
    defaultMessage: 'Health Check Status'
  }),
  id: 'healthCheckStatus',
  component: /*#__PURE__*/_react.default.createElement(_components.HealthCheckPanel, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.agentPolicyDebugger.title', {
    defaultMessage: 'Agent Policy Debugger'
  }),
  id: 'agentPolicyDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyDebugger, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.title', {
    defaultMessage: 'Integration Debugger'
  }),
  id: 'integrationDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.IntegrationDebugger, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.title', {
    defaultMessage: 'Saved Object Debugger'
  }),
  id: 'savedObjectDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.SavedObjectDebugger, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.fleetIndexDebugger.title', {
    defaultMessage: 'Fleet Index Debugger'
  }),
  id: 'fleetIndexDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.FleetIndexDebugger, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.title', {
    defaultMessage: 'Preconfiguration Debugger'
  }),
  id: 'preconfigurationDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.PreconfigurationDebugger, null)
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title', {
    defaultMessage: 'Orphaned Integration Policy Debugger'
  }),
  id: 'orphanedIntegrationPolicyDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.OrphanedIntegrationPolicyDebugger, null)
}];
const DebugPage = ({
  isInitialized,
  setupError
}) => {
  const {
    chrome
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  chrome.docTitle.change(['Debug', 'Fleet']);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: _i18n.i18n.translate('xpack.fleet.debug.pageTitle', {
      defaultMessage: 'Fleet Debugging Dashboard'
    }),
    iconType: "wrench"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: "Danger zone"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.dangerZone.description",
    defaultMessage: "This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",
    values: {
      strongDestructive: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.debug.dangerZone.destructive",
        defaultMessage: "destructive"
      })),
      strongLossOfData: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.debug.dangerZone.lossOfData",
        defaultMessage: "loss of data"
      }))
    }
  }))), !isInitialized && (setupError === null || setupError === void 0 ? void 0 : setupError.message) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: "Setup error"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.initializationError.description",
    defaultMessage: "{message}. You can use this page to debug the error.",
    values: {
      message: setupError === null || setupError === void 0 ? void 0 : setupError.message
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, panels.map(({
    title,
    id,
    component
  }) => /*#__PURE__*/_react.default.createElement("div", {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h2", null, title))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), component), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.usefulLinks.title",
    defaultMessage: "Useful links"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: [{
      label: _i18n.i18n.translate('xpack.fleet.debug.usefulLinks.viewAgents', {
        defaultMessage: 'View Agents in Fleet UI'
      }),
      href: getHref('agent_list'),
      iconType: 'agentApp',
      target: '_blank'
    }, {
      label: _i18n.i18n.translate('xpack.fleet.debug.usefulLinks.troubleshootingGuide', {
        defaultMessage: 'Troubleshooting Guide'
      }),
      href: 'https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html',
      iconType: 'popout',
      target: '_blank'
    }]
  })))), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }));
};
exports.DebugPage = DebugPage;