"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentExportCSVModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _columns = require("./columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentExportCSVModal = ({
  onClose,
  onSubmit,
  agentCount
}) => {
  const [selection, setSelection] = (0, _react.useState)(_columns.INITIAL_AGENT_FIELDS_TO_EXPORT);
  const items = (0, _lodash.uniqBy)([..._columns.INITIAL_AGENT_FIELDS_TO_EXPORT, ..._columns.AGENT_FIELDS_TO_EXPORT], 'field');
  const columns = [{
    field: 'field',
    name: 'Field',
    truncateText: true
  }, {
    field: 'description',
    name: 'Description',
    truncateText: true
  }];
  const selectionValue = {
    selectable: () => true,
    onSelectionChange: newSelection => {
      setSelection(newSelection);
    },
    initialSelected: _columns.INITIAL_AGENT_FIELDS_TO_EXPORT
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "agentExportCSVModal",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.exportCSV.modalTitle",
      defaultMessage: "Download table results as a CSV file"
    }),
    onCancel: onClose,
    onConfirm: () => onSubmit(selection.map(s => ({
      field: s.field
    }))),
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.exportCSV.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.exportCSV.confirmButtonLabel",
      defaultMessage: "Download CSV"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.exportCSV.agentsCountText",
    defaultMessage: "Agents"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    size: "m"
  }, agentCount)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.exportCSV.modalTableDescription",
    defaultMessage: "Select the table columns to display in the CSV file"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: "Column",
    items: items,
    itemId: "field",
    columns: columns,
    selection: selectionValue
  }))));
};
exports.AgentExportCSVModal = AgentExportCSVModal;