"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _dashboard_helpers = require("../../services/dashboard_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardExists = dashboardId => {
  const {
    dashboard: dashboardPlugin
  } = (0, _hooks.useStartServices)();
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['dashboard_exists', dashboardId],
    queryFn: async () => {
      try {
        const findDashboardsService = await dashboardPlugin.findDashboardsService();
        const [dashboard] = await findDashboardsService.findByIds([dashboardId]);
        return (dashboard === null || dashboard === void 0 ? void 0 : dashboard.status) === 'success';
      } catch (e) {
        return false;
      }
    }
  });
  return {
    dashboardExists: data !== null && data !== void 0 ? data : false,
    loading: isLoading
  };
};
const DashboardsButtons = () => {
  const {
    data
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(_constants.FLEET_ELASTIC_AGENT_PACKAGE);
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const getDashboardHref = dashboardId => {
    return (dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId
    })) || '';
  };
  const elasticAgentOverviewDashboardId = (0, _dashboard_helpers.getDashboardIdForSpace)(spaceId, data, _constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_OVERVIEW);
  const elasticAgentInfoDashboardId = (0, _dashboard_helpers.getDashboardIdForSpace)(spaceId, data, _constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_AGENT_INFO);
  const {
    dashboardExists,
    loading: dashboardLoading
  } = useDashboardExists(elasticAgentOverviewDashboardId);
  if (dashboardLoading || !dashboardExists) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(elasticAgentOverviewDashboardId),
    "data-test-subj": "ingestOverviewLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.ingestOverviewlinkButton",
    defaultMessage: "Ingest Overview Metrics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(elasticAgentInfoDashboardId),
    "data-test-subj": "agentInfoLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentInfoLinkButton",
    defaultMessage: "Agent Info Metrics"
  })))));
};
exports.DashboardsButtons = DashboardsButtons;