"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOtherDaysActions = getOtherDaysActions;
exports.getTodayActions = getTodayActions;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const today = () => new Date().toISOString().substring(0, 10);
function getOtherDaysActions(actions) {
  const otherDays = {};
  actions.filter(a => !a.creationTime.startsWith(today())).forEach(action => {
    const day = action.creationTime.substring(0, 10);
    if (!otherDays[day]) {
      otherDays[day] = [];
    }
    otherDays[day].push(action);
  });
  return otherDays;
}
function getTodayActions(actions) {
  const todayActions = actions.filter(a => a.creationTime.startsWith(today()));
  return todayActions;
}