"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActivityButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../constants");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentActivityButton = ({
  onClickAgentActivity,
  showAgentActivityTour
}) => {
  var _storage$get;
  const {
    storage,
    uiSettings
  } = (0, _hooks.useStartServices)();
  const [agentActivityTourState, setAgentActivityTourState] = (0, _react.useState)(showAgentActivityTour);
  const isTourHidden = uiSettings.get('hideAnnouncements', false) || ((_storage$get = storage.get(_constants.TOUR_STORAGE_KEYS.AGENT_ACTIVITY)) === null || _storage$get === void 0 ? void 0 : _storage$get.active) === false;
  const setTourAsHidden = () => {
    storage.set(_constants.TOUR_STORAGE_KEYS.AGENT_ACTIVITY, {
      active: false
    });
  };
  (0, _react.useEffect)(() => {
    setAgentActivityTourState(showAgentActivityTour);
  }, [showAgentActivityTour, setAgentActivityTourState]);
  const onFinish = () => {
    setAgentActivityTourState({
      isOpen: false
    });
    setTourAsHidden();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourContent",
      defaultMessage: "Review in progress, completed, and scheduled agent action activity history here anytime."
    })),
    isStepOpen: !isTourHidden && agentActivityTourState.isOpen,
    onFinish: onFinish,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourTitle",
      defaultMessage: "Agent activity history"
    }),
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onFinish
    }, "OK"),
    anchor: "#agentActivityButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      onClickAgentActivity();
      setAgentActivityTourState({
        isOpen: false
      });
    },
    "data-test-subj": "agentActivityButton",
    iconType: "clock",
    id: "agentActivityButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentActivityButton",
    defaultMessage: "Agent activity"
  })));
};
exports.AgentActivityButton = AgentActivityButton;