"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMetadata = void 0;
var _pick = _interopRequireDefault(require("lodash/pick"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

// Use class/interface merging to define instance properties from FieldMetadataPlain.
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class FieldMetadata {
  constructor(fieldMetadata) {
    Object.assign(this, fieldMetadata);
  }
  pick(props) {
    return (0, _pick.default)(this, props);
  }
  toPlain() {
    return Object.assign({}, this);
  }
  static create(fieldMetadata) {
    var _fieldMetadata$flat_n, _fieldMetadata$dashed, _fieldMetadata$normal, _fieldMetadata$short, _fieldMetadata$source, _fieldMetadata$type;
    const flat_name = (_fieldMetadata$flat_n = fieldMetadata.flat_name) !== null && _fieldMetadata$flat_n !== void 0 ? _fieldMetadata$flat_n : fieldMetadata.name;
    const dashed_name = (_fieldMetadata$dashed = fieldMetadata.dashed_name) !== null && _fieldMetadata$dashed !== void 0 ? _fieldMetadata$dashed : FieldMetadata.toDashedName(flat_name);
    const normalize = (_fieldMetadata$normal = fieldMetadata.normalize) !== null && _fieldMetadata$normal !== void 0 ? _fieldMetadata$normal : [];
    const short = (_fieldMetadata$short = fieldMetadata.short) !== null && _fieldMetadata$short !== void 0 ? _fieldMetadata$short : fieldMetadata.description;
    const source = (_fieldMetadata$source = fieldMetadata.source) !== null && _fieldMetadata$source !== void 0 ? _fieldMetadata$source : 'unknown';
    const type = (_fieldMetadata$type = fieldMetadata.type) !== null && _fieldMetadata$type !== void 0 ? _fieldMetadata$type : 'unknown';
    const fieldMetadataProps = {
      ...fieldMetadata,
      dashed_name,
      flat_name,
      normalize,
      short,
      source,
      type
    };
    return new FieldMetadata(fieldMetadataProps);
  }
  static toDashedName(flatName) {
    return flatName.split('.').join('-');
  }
}
exports.FieldMetadata = FieldMetadata;