"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextDecoration = exports.TextAlignment = exports.Overflow = exports.FontWeight = exports.FontStyle = exports.FontSizeUnit = exports.BackgroundSize = exports.BackgroundRepeat = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Enum of supported CSS `background-repeat` properties.
 */
let BackgroundRepeat = exports.BackgroundRepeat = /*#__PURE__*/function (BackgroundRepeat) {
  BackgroundRepeat["REPEAT"] = "repeat";
  BackgroundRepeat["REPEAT_NO"] = "no-repeat";
  BackgroundRepeat["REPEAT_X"] = "repeat-x";
  BackgroundRepeat["REPEAT_Y"] = "repeat-y";
  BackgroundRepeat["ROUND"] = "round";
  BackgroundRepeat["SPACE"] = "space";
  return BackgroundRepeat;
}({});
/**
 * Enum of supported CSS `background-size` properties.
 */
let BackgroundSize = exports.BackgroundSize = /*#__PURE__*/function (BackgroundSize) {
  BackgroundSize["AUTO"] = "auto";
  BackgroundSize["CONTAIN"] = "contain";
  BackgroundSize["COVER"] = "cover";
  return BackgroundSize;
}({});
/**
 * Enum of supported CSS `font-style` properties.
 */
let FontStyle = exports.FontStyle = /*#__PURE__*/function (FontStyle) {
  FontStyle["ITALIC"] = "italic";
  FontStyle["NORMAL"] = "normal";
  return FontStyle;
}({});
/**
 * Enum of supported CSS `font-weight` properties.
 */
let FontWeight = exports.FontWeight = /*#__PURE__*/function (FontWeight) {
  FontWeight["NORMAL"] = "normal";
  FontWeight["BOLD"] = "bold";
  FontWeight["BOLDER"] = "bolder";
  FontWeight["LIGHTER"] = "lighter";
  FontWeight["ONE"] = "100";
  FontWeight["TWO"] = "200";
  FontWeight["THREE"] = "300";
  FontWeight["FOUR"] = "400";
  FontWeight["FIVE"] = "500";
  FontWeight["SIX"] = "600";
  FontWeight["SEVEN"] = "700";
  FontWeight["EIGHT"] = "800";
  FontWeight["NINE"] = "900";
  return FontWeight;
}({});
/**
 * Enum of supported CSS `overflow` properties.
 */
let Overflow = exports.Overflow = /*#__PURE__*/function (Overflow) {
  Overflow["AUTO"] = "auto";
  Overflow["HIDDEN"] = "hidden";
  Overflow["SCROLL"] = "scroll";
  Overflow["VISIBLE"] = "visible";
  return Overflow;
}({});
/**
 * Enum of supported CSS `text-align` properties.
 */
let TextAlignment = exports.TextAlignment = /*#__PURE__*/function (TextAlignment) {
  TextAlignment["CENTER"] = "center";
  TextAlignment["JUSTIFY"] = "justify";
  TextAlignment["LEFT"] = "left";
  TextAlignment["RIGHT"] = "right";
  return TextAlignment;
}({});
/**
 * Enum of supported CSS `text-decoration` properties.
 */
let TextDecoration = exports.TextDecoration = /*#__PURE__*/function (TextDecoration) {
  TextDecoration["NONE"] = "none";
  TextDecoration["UNDERLINE"] = "underline";
  return TextDecoration;
}({});
let FontSizeUnit = exports.FontSizeUnit = /*#__PURE__*/function (FontSizeUnit) {
  FontSizeUnit["PX"] = "px";
  FontSizeUnit["PT"] = "pt";
  return FontSizeUnit;
}({});
/**
 * Represents the various style properties that can be applied to an element.
 */
/**
 * Represents an object containing style information for a Container.
 */
/**
 * An object that represents style information, typically CSS.
 */