"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesFilter = SeriesFilter;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filter_expanded = require("./filter_expanded");
var _constants = require("../../configurations/constants/constants");
var _selected_filters = require("./selected_filters");
var _labels_filter = require("../components/labels_filter");
var _url_search = require("../../components/url_search/url_search");
var _elasticsearch_fieldnames = require("../../configurations/constants/elasticsearch_fieldnames");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeriesFilter({
  series,
  seriesConfig,
  seriesId
}) {
  const options = seriesConfig.filterFields.filter(field => field !== _elasticsearch_fieldnames.TRANSACTION_URL).map(field => {
    var _seriesConfig$labels$2, _seriesConfig$labels2;
    if (typeof field === 'string') {
      var _ref, _seriesConfig$labels$, _seriesConfig$labels;
      return {
        label: (_ref = (_seriesConfig$labels$ = (_seriesConfig$labels = seriesConfig.labels) === null || _seriesConfig$labels === void 0 ? void 0 : _seriesConfig$labels[field]) !== null && _seriesConfig$labels$ !== void 0 ? _seriesConfig$labels$ : _constants.FieldLabels[field]) !== null && _ref !== void 0 ? _ref : field,
        field
      };
    }
    return {
      field: field.field,
      nestedField: field.nested,
      isNegated: field.isNegated,
      label: ((_seriesConfig$labels$2 = (_seriesConfig$labels2 = seriesConfig.labels) === null || _seriesConfig$labels2 === void 0 ? void 0 : _seriesConfig$labels2[field.field]) !== null && _seriesConfig$labels$2 !== void 0 ? _seriesConfig$labels$2 : _constants.FieldLabels[field.field]) || field.field
    };
  });
  const hasUrlFilter = (0, _react.useMemo)(() => {
    return seriesConfig.filterFields.some(field => {
      if (typeof field === 'string') {
        return field === _elasticsearch_fieldnames.TRANSACTION_URL;
      } else if (field.field !== undefined) {
        return field.field === _elasticsearch_fieldnames.TRANSACTION_URL;
      } else {
        return false;
      }
    });
  }, [seriesConfig]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, hasUrlFilter ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_url_search.URLSearch, {
    series: series,
    seriesId: seriesId,
    seriesConfig: seriesConfig
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, options.map(opt => opt.field === _constants.LABEL_FIELDS_FILTER ? /*#__PURE__*/_react.default.createElement(_labels_filter.LabelsFieldFilter, (0, _extends2.default)({
    series: series,
    key: opt.label,
    seriesId: seriesId,
    baseFilters: seriesConfig.baseFilters
  }, opt)) : /*#__PURE__*/_react.default.createElement(_filter_expanded.FilterExpanded, (0, _extends2.default)({
    series: series,
    key: opt.label,
    seriesId: seriesId,
    baseFilters: seriesConfig.baseFilters
  }, opt)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_selected_filters.SelectedFilters, {
    seriesId: seriesId,
    series: series,
    seriesConfig: seriesConfig
  }));
}