"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _esqlTypes = require("@kbn/esql-types");
var _ = require("../../../..");
var _types = require("../../../definitions/types");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
var _helper = require("../../helper");
var _util = require("./util");
var _constants = require("../../../shared/constants");
var _context = require("../../../shared/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText,
  command,
  columnExists,
  getColumnsByType,
  getSuggestedUserDefinedColumnName,
  getPreferences,
  getVariables,
  supportsControls,
  getExpressionType
}) {
  const pos = (0, _util.getPosition)(innerText, command);
  const lastCharacterTyped = innerText[innerText.length - 1];
  const controlSuggestions = (0, _factories.getControlSuggestionIfSupported)(Boolean(supportsControls), _esqlTypes.ESQLVariableType.FUNCTIONS, getVariables, lastCharacterTyped !== _constants.ESQL_VARIABLES_PREFIX);
  switch (pos) {
    case 'expression_without_assignment':
      return [...controlSuggestions, ...(0, _factories.getFunctionSuggestions)({
        location: _types.Location.STATS
      }), (0, _factories.getNewUserDefinedColumnSuggestion)(getSuggestedUserDefinedColumnName())];
    case 'expression_after_assignment':
      return [...controlSuggestions, ...(0, _factories.getFunctionSuggestions)({
        location: _types.Location.STATS
      })];
    case 'expression_complete':
      return [_util.whereCompleteItem, _util.byCompleteItem, _complete_items.pipeCompleteItem, {
        ..._complete_items.commaCompleteItem,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        text: ', '
      }];
    case 'after_where':
      {
        const whereFn = command.args[command.args.length - 1];
        const expressionRoot = (0, _context.isMarkerNode)(whereFn.args[1]) ? undefined : whereFn.args[1];
        if (expressionRoot && !(0, _.isSingleItem)(expressionRoot)) {
          return [];
        }
        const suggestions = await (0, _helper.suggestForExpression)({
          expressionRoot,
          getExpressionType,
          getColumnsByType,
          location: _types.Location.STATS_WHERE,
          innerText,
          preferredExpressionType: 'boolean'
        });

        // Is this a complete boolean expression?
        // If so, we can call it done and suggest a pipe
        const expressionType = getExpressionType(expressionRoot);
        if (expressionType === 'boolean' && (0, _helper.isExpressionComplete)(expressionType, innerText)) {
          suggestions.push(_complete_items.pipeCompleteItem, {
            ..._complete_items.commaCompleteItem,
            text: ', '
          }, _util.byCompleteItem);
        }
        return suggestions;
      }
    case 'grouping_expression_after_assignment':
      {
        var _await$getPreferences;
        const histogramBarTarget = (_await$getPreferences = await (getPreferences === null || getPreferences === void 0 ? void 0 : getPreferences())) === null || _await$getPreferences === void 0 ? void 0 : _await$getPreferences.histogramBarTarget;
        const columnSuggestions = (0, _helper.pushItUpInTheList)(await getColumnsByType('any', [], {
          openSuggestions: true
        }), true);
        return suggestColumns(columnSuggestions, [...(0, _factories.getFunctionSuggestions)({
          location: _types.Location.STATS_BY
        }), (0, _util.getDateHistogramCompletionItem)(histogramBarTarget)], innerText, columnExists);
      }
    case 'grouping_expression_without_assignment':
      {
        var _await$getPreferences2;
        const histogramBarTarget = (_await$getPreferences2 = await (getPreferences === null || getPreferences === void 0 ? void 0 : getPreferences())) === null || _await$getPreferences2 === void 0 ? void 0 : _await$getPreferences2.histogramBarTarget;
        const ignored = alreadyUsedColumns(command);
        const columnSuggestions = (0, _helper.pushItUpInTheList)(await getColumnsByType('any', ignored, {
          openSuggestions: true
        }), true);
        const suggestions = await suggestColumns(columnSuggestions, [...(0, _factories.getFunctionSuggestions)({
          location: _types.Location.STATS_BY
        }), (0, _util.getDateHistogramCompletionItem)(histogramBarTarget)], innerText, columnExists);
        suggestions.push((0, _factories.getNewUserDefinedColumnSuggestion)(getSuggestedUserDefinedColumnName()));
        return suggestions;
      }
    case 'grouping_expression_complete':
      return [_complete_items.pipeCompleteItem, {
        ..._complete_items.commaCompleteItem,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        text: ', '
      }];
    default:
      return [];
  }
}
function alreadyUsedColumns(command) {
  var _byOption$args$filter;
  const byOption = command.args.find(arg => (0, _.isSingleItem)(arg) && arg.name === 'by');
  const columnNodes = (_byOption$args$filter = byOption === null || byOption === void 0 ? void 0 : byOption.args.filter(arg => (0, _.isSingleItem)(arg) && arg.type === 'column')) !== null && _byOption$args$filter !== void 0 ? _byOption$args$filter : [];
  return columnNodes.map(node => node.parts.join('.'));
}
function suggestColumns(columnSuggestions, otherSuggestions, innerText, columnExists) {
  return (0, _helper.handleFragment)(innerText, fragment => columnExists(fragment), async (_fragment, rangeToReplace) => {
    // fie<suggest>
    return [...columnSuggestions.map(suggestion => {
      return {
        ...suggestion,
        text: suggestion.text,
        rangeToReplace
      };
    }), ...otherSuggestions];
  }, (fragment, rangeToReplace) => {
    // field<suggest>
    const finalSuggestions = [{
      ..._complete_items.pipeCompleteItem,
      text: ' | '
    }, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    }];
    return finalSuggestions.map(s => ({
      ...s,
      filterText: fragment,
      text: fragment + s.text,
      command: _factories.TRIGGER_SUGGESTION_COMMAND,
      rangeToReplace
    }));
  });
}