"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortModifierSuggestions = exports.getSortPos = void 0;
var _factories = require("../../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const regexStart = /so?r?(?<start>t?)(.+,)?(?<space1>\s+)?/i;
const regex = /sort(.+,)?((?<space1>\s+)(?<column>[^\s]+)(?<space2>\s*)(?<order>(AS?C?)|(DE?S?C?))?(?<space3>\s*)(?<nulls>NU?L?L?S? ?(FI?R?S?T?|LA?S?T?)?)?(?<space4>\s*))?/i;
const sortModifierSuggestions = exports.sortModifierSuggestions = {
  ASC: {
    label: 'ASC',
    text: 'ASC',
    detail: '',
    kind: 'Keyword',
    sortText: '1-ASC',
    command: _factories.TRIGGER_SUGGESTION_COMMAND
  },
  DESC: {
    label: 'DESC',
    text: 'DESC',
    detail: '',
    kind: 'Keyword',
    sortText: '1-DESC',
    command: _factories.TRIGGER_SUGGESTION_COMMAND
  },
  NULLS_FIRST: {
    label: 'NULLS FIRST',
    text: 'NULLS FIRST',
    detail: '',
    kind: 'Keyword',
    sortText: '2-NULLS FIRST',
    command: _factories.TRIGGER_SUGGESTION_COMMAND
  },
  NULLS_LAST: {
    label: 'NULLS LAST',
    text: 'NULLS LAST',
    detail: '',
    kind: 'Keyword',
    sortText: '2-NULLS LAST',
    command: _factories.TRIGGER_SUGGESTION_COMMAND
  }
};
const getSortPos = query => {
  var _match$groups, _match$groups2, _match$groups3, _match$groups4, _match$groups5, _match$groups6;
  const match = query.match(regex);
  let pos = 'none';
  let nulls = '';
  if (match !== null && match !== void 0 && (_match$groups = match.groups) !== null && _match$groups !== void 0 && _match$groups.space4) {
    pos = 'space4';
  } else if (match !== null && match !== void 0 && (_match$groups2 = match.groups) !== null && _match$groups2 !== void 0 && _match$groups2.nulls) {
    pos = 'nulls';
    nulls = match.groups.nulls.toUpperCase();
  } else if (match !== null && match !== void 0 && (_match$groups3 = match.groups) !== null && _match$groups3 !== void 0 && _match$groups3.space3) {
    pos = 'space3';
  } else if (match !== null && match !== void 0 && (_match$groups4 = match.groups) !== null && _match$groups4 !== void 0 && _match$groups4.order) {
    pos = 'order';
  } else if (match !== null && match !== void 0 && (_match$groups5 = match.groups) !== null && _match$groups5 !== void 0 && _match$groups5.space2) {
    pos = 'space2';
  } else if (match !== null && match !== void 0 && (_match$groups6 = match.groups) !== null && _match$groups6 !== void 0 && _match$groups6.column) {
    pos = 'column';
  } else {
    var _match2$groups, _match2$groups2;
    const match2 = query.match(regexStart);
    if (match2 !== null && match2 !== void 0 && (_match2$groups = match2.groups) !== null && _match2$groups !== void 0 && _match2$groups.space1) {
      pos = 'space1';
    } else if (match2 !== null && match2 !== void 0 && (_match2$groups2 = match2.groups) !== null && _match2$groups2 !== void 0 && _match2$groups2.start) {
      pos = 'start';
    } else if (match2) {
      pos = 'pre-start';
    }
  }
  return {
    pos,
    nulls
  };
};
exports.getSortPos = getSortPos;