"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsSuggestionsAfter = void 0;
var _uniqBy = _interopRequireDefault(require("lodash/uniqBy"));
var _helpers = require("../../../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fieldsSuggestionsAfter = (command, previousCommandFields, userDefinedColumns) => {
  const asRenamePairs = [];
  const assignRenamePairs = [];
  for (const arg of command.args) {
    if ((0, _helpers.isFunctionItem)(arg)) {
      if (arg.name === 'as') {
        asRenamePairs.push(arg);
      } else if (arg.name === '=') {
        assignRenamePairs.push(arg);
      }
    }
  }

  // rename the columns with the user defined name
  const newFields = previousCommandFields.map(oldColumn => {
    var _asRenamePair$args, _assignRenamePair$arg;
    const asRenamePair = asRenamePairs.find(pair => {
      var _pair$args, _pair$args$;
      return (pair === null || pair === void 0 ? void 0 : (_pair$args = pair.args) === null || _pair$args === void 0 ? void 0 : (_pair$args$ = _pair$args[0]) === null || _pair$args$ === void 0 ? void 0 : _pair$args$.name) === oldColumn.name;
    });
    if (asRenamePair !== null && asRenamePair !== void 0 && (_asRenamePair$args = asRenamePair.args) !== null && _asRenamePair$args !== void 0 && _asRenamePair$args[1]) {
      return {
        name: asRenamePair.args[1].name,
        type: oldColumn.type
      };
    }
    const assignRenamePair = assignRenamePairs.find(pair => {
      var _pair$args2, _pair$args2$;
      return (pair === null || pair === void 0 ? void 0 : (_pair$args2 = pair.args) === null || _pair$args2 === void 0 ? void 0 : (_pair$args2$ = _pair$args2[1]) === null || _pair$args2$ === void 0 ? void 0 : _pair$args2$.name) === oldColumn.name;
    });
    if (assignRenamePair !== null && assignRenamePair !== void 0 && (_assignRenamePair$arg = assignRenamePair.args) !== null && _assignRenamePair$arg !== void 0 && _assignRenamePair$arg[0]) {
      return {
        name: assignRenamePair.args[0].name,
        type: oldColumn.type
      };
    }
    return oldColumn; // No rename found, keep the old name
  });
  return (0, _uniqBy.default)(newFields, 'name');
};
exports.fieldsSuggestionsAfter = fieldsSuggestionsAfter;