"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAppSearchGatedFormRoute = registerAppSearchGatedFormRoute;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAppSearchGatedFormRoute({
  router,
  enterpriseSearchRequestHandler
}) {
  router.post({
    path: '/internal/app_search/as_gate',
    validate: {
      body: _configSchema.schema.object({
        as_gate_data: _configSchema.schema.object({
          additional_feedback: _configSchema.schema.maybe(_configSchema.schema.string()),
          feature: _configSchema.schema.string(),
          features_other: _configSchema.schema.maybe(_configSchema.schema.string()),
          participate_in_ux_labs: _configSchema.schema.maybe(_configSchema.schema.boolean())
        })
      })
    }
  }, enterpriseSearchRequestHandler.createRequest({
    path: '/api/ent/v2/internal/as_gate'
  }));
}