"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _telemetry = require("../../../shared/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingCard = ({
  title,
  icon,
  description,
  actionTitle,
  testSubj,
  actionPath,
  complete
}) => {
  const {
    sendWorkplaceSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const onClick = () => sendWorkplaceSearchTelemetry({
    action: 'clicked',
    metric: 'onboarding_card_button'
  });
  const completeButton = actionPath ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: actionPath,
    "data-test-subj": testSubj,
    onClick: onClick,
    fill: true
  }, actionTitle) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": testSubj
  }, actionTitle);
  const incompleteButton = actionPath ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: actionPath,
    "data-test-subj": testSubj,
    onClick: onClick,
    fill: true
  }, actionTitle) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": testSubj
  }, actionTitle);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: complete ? 'checkInCircleFilled' : icon,
    iconColor: complete ? 'success' : 'subdued',
    title: /*#__PURE__*/_react.default.createElement("h2", null, title),
    body: description,
    actions: complete ? completeButton : incompleteButton
  })));
};
exports.OnboardingCard = OnboardingCard;