"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGatedFormData = exports.UpdateGatedFormDataApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendGatedFormData = async ({
  feature,
  featuresOther,
  additionalFeedback,
  participateInUXLabs
}) => {
  return await _http.HttpLogic.values.http.post('/internal/workplace_search/ws_gate', {
    body: JSON.stringify({
      ws_gate_data: {
        additional_feedback: additionalFeedback != null ? additionalFeedback : undefined,
        feature,
        features_other: featuresOther != null ? featuresOther : undefined,
        participate_in_ux_labs: participateInUXLabs != null ? participateInUXLabs : undefined
      }
    })
  });
};
exports.sendGatedFormData = sendGatedFormData;
const UpdateGatedFormDataApiLogic = exports.UpdateGatedFormDataApiLogic = (0, _create_api_logic.createApiLogic)(['workplace_search', 'send_gatedForm_data_api_logic'], sendGatedFormData);