"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Frequency = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../shared/constants");
var _doc_links = require("../../../../../shared/doc_links");
var _unsaved_changes_prompt = require("../../../../../shared/unsaved_changes_prompt");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants2 = require("../../../../constants");
var _constants3 = require("../../constants");
var _source_logic = require("../../source_logic");
var _source_layout = require("../source_layout");
var _blocked_window_tab = require("./blocked_window_tab");
var _sync_frequency_tab = require("./sync_frequency_tab");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Frequency = ({
  tabId
}) => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    hasUnsavedFrequencyChanges,
    navigatingBetweenTabs
  } = (0, _kea.useValues)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    handleSelectedTabChanged,
    resetSyncSettings,
    updateFrequencySettings
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const tabs = [{
    id: 'source_sync_frequency',
    name: _constants3.SOURCE_SYNC_FREQUENCY_TITLE,
    content: /*#__PURE__*/_react.default.createElement(_sync_frequency_tab.SyncFrequency, null)
  }, {
    id: 'blocked_time_windows',
    name: _constants3.BLOCKED_TIME_WINDOWS_TITLE,
    content: /*#__PURE__*/_react.default.createElement(_blocked_window_tab.BlockedWindows, null)
  }];
  const onSelectedTabChanged = tab => {
    handleSelectedTabChanged(tab.id);
  };
  const actions = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: resetSyncSettings,
    disabled: !hasUnsavedFrequencyChanges
  }, _constants2.RESET_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: updateFrequencySettings,
    disabled: !hasUnsavedFrequencyChanges
  }, _constants.SAVE_BUTTON_LABEL)));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants2.NAV.SYNCHRONIZATION_FREQUENCY, tabId === 0 ? _constants3.SOURCE_SYNC_FREQUENCY_TITLE : _constants3.BLOCKED_TIME_WINDOWS_TITLE],
    pageViewTelemetry: "source_synchronization_frequency",
    isLoading: false
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: !navigatingBetweenTabs && hasUnsavedFrequencyChanges,
    messageText: _constants3.SYNC_UNSAVED_CHANGES_MESSAGE
  }), /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.NAV.SYNCHRONIZATION_FREQUENCY,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants3.SOURCE_FREQUENCY_DESCRIPTION, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.workplaceSearchIndexingSchedule,
      external: true
    }, _constants3.LEARN_MORE_LINK)),
    action: actions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: tabs[tabId],
    onTabClick: onSelectedTabChanged
  }));
};
exports.Frequency = Frequency;