"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExampleStandoutResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _utils = require("../../../../utils");
var _custom_source_icon = require("./custom_source_icon");
var _display_settings_logic = require("./display_settings_logic");
var _subtitle_field = require("./subtitle_field");
var _title_field = require("./title_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExampleStandoutResult = () => {
  const {
    sourceName,
    searchResultConfig: {
      titleField,
      subtitleField,
      descriptionField,
      typeField,
      mediaTypeField,
      createdByField,
      updatedByField,
      color
    },
    titleFieldHover,
    subtitleFieldHover,
    descriptionFieldHover,
    typeFieldHover,
    mediaTypeFieldHover,
    createdByFieldHover,
    updatedByFieldHover,
    exampleDocuments
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  const result = exampleDocuments[0];
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "example-standout-result",
    "data-test-subj": "ExampleStandoutResult"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "example-standout-result__header",
    style: {
      backgroundColor: color
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_source_icon.CustomSourceIcon, {
    color: _eui.isColorDark.apply(null, (0, _eui.hexToRgb)(color)) ? 'white' : 'black'
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "example-standout-result__source-name",
    style: {
      color: _eui.isColorDark.apply(null, (0, _eui.hexToRgb)(color)) ? 'white' : 'black'
    }
  }, sourceName)), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-standout-result__content"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-content"
  }, /*#__PURE__*/_react.default.createElement(_title_field.TitleField, {
    titleFieldHover: titleFieldHover,
    titleField: titleField,
    result: result
  }), /*#__PURE__*/_react.default.createElement(_subtitle_field.SubtitleField, {
    subtitleFieldHover: subtitleFieldHover,
    subtitleField: subtitleField,
    result: result
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('example-result-content__description', {
      'example-result-field-hover': descriptionFieldHover
    })
  }, descriptionField ? /*#__PURE__*/_react.default.createElement("span", null, result[descriptionField]) : /*#__PURE__*/_react.default.createElement("span", {
    className: "example-result-content-placeholder",
    "data-test-subj": "DefaultDescriptionLabel"
  }, _constants.DESCRIPTION_LABEL)), createdByField && result[createdByField] && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('example-result-content__subtitle', {
      'example-result-field-hover': createdByFieldHover
    }),
    "data-test-subj": "CreatedByField"
  }, "Created by ", result[createdByField]), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-content__meta"
  }, typeField && result[typeField] && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('example-result-content__tag', {
      'example-result-field-hover': typeFieldHover
    }),
    "data-test-subj": "TypeField"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "example-search-result__tag-content"
  }, result[typeField])), mediaTypeField && result[mediaTypeField] && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('example-result-content__tag', {
      'example-result-field-hover': mediaTypeFieldHover
    }),
    "data-test-subj": "MediaTypeField"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "example-search-result__tag-content"
  }, (0, _utils.mimeType)(result[mediaTypeField]))), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-content__tag-content"
  }, /*#__PURE__*/_react.default.createElement("span", null, "Last updated\xA0", updatedByField && result[updatedByField] && /*#__PURE__*/_react.default.createElement("span", {
    className: (0, _classnames.default)('example-result-content__tag-content', {
      'example-result-field-hover': updatedByFieldHover
    }),
    "data-test-subj": "UpdatedByField"
  }, ' ', "by ", result[updatedByField], "\xA0"), (0, _utils.getAsLocalDateTimeString)(result.last_updated) || result.last_updated))))));
};
exports.ExampleStandoutResult = ExampleStandoutResult;