"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectInstance = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _licensing = require("../../../../../shared/licensing");
var _app_logic = require("../../../../app_logic");
var _types = require("../../../../types");
var _add_source_logic = require("./add_source_logic");
var _document_permissions_callout = require("./document_permissions_callout");
var _document_permissions_field = require("./document_permissions_field");
var _source_features = require("./source_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectInstance = ({
  configuration: {
    needsSubdomain,
    hasOauthRedirect,
    needsCredentials
  },
  features,
  objTypes,
  name,
  needsPermissions,
  onFormCreated,
  header
}) => {
  var _features$basicOrgCon;
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    getSourceConnectData,
    createContentSource,
    setSourceLoginValue,
    setSourcePasswordValue,
    setSourceSubdomainValue,
    setSourceIndexPermissionsValue
  } = (0, _kea.useActions)(_add_source_logic.AddSourceLogic);
  const {
    buttonLoading,
    loginValue,
    passwordValue,
    indexPermissionsValue,
    subdomainValue,
    sourceConfigData: {
      connectionRequiresRedirect
    }
  } = (0, _kea.useValues)(_add_source_logic.AddSourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);

  // Default indexPermissions to true, if needed
  (0, _react.useEffect)(() => {
    setSourceIndexPermissionsValue(needsPermissions && isOrganization && hasPlatinumLicense);
  }, []);
  const doRedirect = hasOauthRedirect || connectionRequiresRedirect;
  const redirectOauth = oauthUrl => window.location.replace(oauthUrl);
  const redirectFormCreated = () => onFormCreated(name);
  const onOauthFormSubmit = () => getSourceConnectData(redirectOauth);
  const onCredentialsFormSubmit = () => createContentSource(redirectFormCreated);
  const handleFormSubmit = e => {
    e.preventDefault();
    const onSubmit = doRedirect ? onOauthFormSubmit : onCredentialsFormSubmit;
    onSubmit();
  };
  const permissionsExcluded = features === null || features === void 0 ? void 0 : (_features$basicOrgCon = features.basicOrgContextExcludedFeatures) === null || _features$basicOrgCon === void 0 ? void 0 : _features$basicOrgCon.includes(_types.FeatureIds.DocumentLevelPermissions);
  const credentialsFields = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Login"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    required: true,
    name: "login",
    value: loginValue,
    onChange: e => setSourceLoginValue(e.target.value),
    "data-test-subj": "LoginField"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Password"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    required: true,
    name: "password",
    type: "password",
    value: passwordValue,
    onChange: e => setSourcePasswordValue(e.target.value),
    "data-test-subj": "PasswordField"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
  const subdomainField = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Subdomain"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    required: true,
    name: "subdomain",
    value: subdomainValue,
    onChange: e => setSourceSubdomainValue(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
  const permissionField = /*#__PURE__*/_react.default.createElement(_document_permissions_field.DocumentPermissionsField, {
    needsPermissions: needsPermissions,
    indexPermissionsValue: indexPermissionsValue,
    setValue: setSourceIndexPermissionsValue
  });
  const formFields = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOrganization && hasPlatinumLicense && permissionField, needsCredentials && credentialsFields, needsSubdomain && subdomainField, permissionsExcluded && !hasPlatinumLicense && /*#__PURE__*/_react.default.createElement(_document_permissions_callout.DocumentPermissionsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    type: "submit",
    fill: true,
    isLoading: buttonLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.connect.button', {
    defaultMessage: 'Connect {name}',
    values: {
      name
    }
  }))));
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "adding-a-source__connect-an-instance"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    color: "subdued"
  }, header), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_source_features.SourceFeatures, {
    features: features,
    name: name,
    objTypes: objTypes
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), formFields)));
};
exports.ConnectInstance = ConnectInstance;